"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsInfoButton = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _kibana = require("../../contexts/kibana");
var _get_field_icon_types = require("../../../../common/util/get_field_icon_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldStatsInfoButton = ({
  field,
  label,
  onButtonClick,
  disabled,
  isEmpty = false,
  hideTrigger = false
}) => {
  const themeVars = (0, _kibana.useCurrentThemeVars)();
  const emptyFieldMessage = isEmpty ? ' ' + _i18n.i18n.translate('xpack.ml.newJob.wizard.fieldContextPopover.emptyFieldInSampleDocsMsg', {
    defaultMessage: '(no data found in 1000 sample records)'
  }) : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !hideTrigger ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.newJob.wizard.fieldContextPopover.inspectFieldStatsTooltip', {
      defaultMessage: 'Inspect field statistics'
    }) + emptyFieldMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `mlInspectFieldStatsButton-${field.id}`,
    disabled: disabled === true,
    size: "xs",
    iconType: "inspect",
    css: {
      color: isEmpty ? themeVars.euiTheme.euiColorDisabled : undefined
    },
    onClick: ev => {
      if (ev.type === 'click') {
        ev.currentTarget.focus();
      }
      ev.preventDefault();
      ev.stopPropagation();
      if (onButtonClick) {
        onButtonClick(field);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.fieldContextPopover.inspectFieldStatsTooltipAriaLabel', {
      defaultMessage: 'Inspect field statistics'
    }) + emptyFieldMessage
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingRight: themeVars.euiTheme.euiSizeXS,
      paddingBottom: themeVars.euiTheme.euiSizeXS
    }
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    color: isEmpty ? themeVars.euiTheme.euiColorDisabled : undefined,
    type: (0, _get_field_icon_types.getKbnFieldIconType)(field.type),
    fill: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isEmpty ? 'subdued' : undefined,
    size: "s",
    "aria-label": label,
    title: label,
    className: "euiComboBoxOption__content",
    css: {
      paddingBottom: themeVars.euiTheme.euiSizeXS
    }
  }, label));
};
exports.FieldStatsInfoButton = FieldStatsInfoButton;