"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataRecognizer = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _recognized_result = require("./recognized_result");
var _ml_api_service = require("../../services/ml_api_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataRecognizer extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      results: []
    };
    this.indexPattern = props.indexPattern;
    this.savedSearch = props.savedSearch;
    this.className = props.className;
    this.results = props.results;
  }
  componentDidMount() {
    // once the mount is complete, call the recognize endpoint to see if the index format is known to us,
    _ml_api_service.ml.recognizeIndex({
      indexPatternTitle: this.indexPattern.title
    }).then(resp => {
      // Sort results by title prior to display
      resp.sort((res1, res2) => res1.title.localeCompare(res2.title));
      const results = resp.map(r => /*#__PURE__*/_react.default.createElement(_recognized_result.RecognizedResult, {
        key: r.id,
        config: r,
        indexPattern: this.indexPattern,
        savedSearch: this.savedSearch
      }));
      if (typeof this.results === 'object') {
        this.results.count = results.length;
        if (typeof this.results.onChange === 'function') {
          this.results.onChange();
        }
      }
      this.setState({
        results
      });
    }).catch(e => {
      console.error('Error attempting to recognize index', e);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.state.results);
  }
}
exports.DataRecognizer = DataRecognizer;
DataRecognizer.propTypes = {
  indexPattern: _propTypes.default.object,
  savedSearch: _propTypes.default.object,
  className: _propTypes.default.string,
  results: _propTypes.default.object
};