"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDataViewButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateDataViewButton = ({
  onDataViewCreated,
  allowAdHocDataView = false
}) => {
  const {
    dataViewEditor
  } = (0, _kibana.useMlKibana)().services;
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView());
  const closeDataViewEditorRef = (0, _react.useRef)();
  const createNewDataView = (0, _react.useCallback)(() => {
    closeDataViewEditorRef.current = dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.openEditor({
      onSave: async dataView => {
        if (dataView.id && onDataViewCreated) {
          onDataViewCreated(dataView.id, 'index-pattern', dataView.name);
        }
      },
      allowAdHocDataView
    });
  }, [onDataViewCreated, dataViewEditor, allowAdHocDataView]);
  (0, _react.useEffect)(function cleanUpFlyout() {
    return () => {
      // Close the editor when unmounting
      if (closeDataViewEditorRef.current) {
        closeDataViewEditorRef.current();
      }
    };
  }, []);
  return canEditDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createNewDataView,
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "newDataViewButton",
    disabled: !canEditDataView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.savedObjectFinder.createADataView",
    defaultMessage: "Create a data view"
  })) : null;
};
exports.CreateDataViewButton = CreateDataViewButton;