"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRIAL_LICENSE = exports.MlLicense = exports.MINIMUM_LICENSE = exports.MINIMUM_FULL_LICENSE = void 0;
exports.isFullLicense = isFullLicense;
exports.isMinimumLicense = isMinimumLicense;
exports.isMlEnabled = isMlEnabled;
exports.isTrialLicense = isTrialLicense;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _app = require("../constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_LICENSE = 'basic';
exports.MINIMUM_LICENSE = MINIMUM_LICENSE;
const MINIMUM_FULL_LICENSE = 'platinum';
exports.MINIMUM_FULL_LICENSE = MINIMUM_FULL_LICENSE;
const TRIAL_LICENSE = 'trial';
exports.TRIAL_LICENSE = TRIAL_LICENSE;
class MlLicense {
  constructor() {
    (0, _defineProperty2.default)(this, "_licenseSubscription", null);
    (0, _defineProperty2.default)(this, "_license", null);
    (0, _defineProperty2.default)(this, "_isSecurityEnabled", false);
    (0, _defineProperty2.default)(this, "_hasLicenseExpired", false);
    (0, _defineProperty2.default)(this, "_isMlEnabled", false);
    (0, _defineProperty2.default)(this, "_isMinimumLicense", false);
    (0, _defineProperty2.default)(this, "_isFullLicense", false);
    (0, _defineProperty2.default)(this, "_isTrialLicense", false);
    (0, _defineProperty2.default)(this, "_licenseInfo$", new _rxjs.BehaviorSubject({
      license: this._license,
      isSecurityEnabled: this._isSecurityEnabled,
      hasLicenseExpired: this._hasLicenseExpired,
      isMlEnabled: this._isMlEnabled,
      isMinimumLicense: this._isMinimumLicense,
      isFullLicense: this._isFullLicense,
      isTrialLicense: this._isTrialLicense
    }));
    (0, _defineProperty2.default)(this, "licenseInfo$", this._licenseInfo$.pipe((0, _operators.distinctUntilChanged)(_lodash.isEqual)));
    (0, _defineProperty2.default)(this, "isLicenseReady$", this._licenseInfo$.pipe((0, _operators.map)(v => !!v.license), (0, _operators.distinctUntilChanged)()));
  }
  setup(license$, callback) {
    this._licenseSubscription = license$.subscribe(license => {
      const {
        isEnabled: securityIsEnabled
      } = license.getFeature('security');
      const mlLicenseUpdate = {
        license,
        isSecurityEnabled: securityIsEnabled,
        hasLicenseExpired: license.status === 'expired',
        isMlEnabled: license.getFeature(_app.PLUGIN_ID).isEnabled,
        isMinimumLicense: isMinimumLicense(license),
        isFullLicense: isFullLicense(license),
        isTrialLicense: isTrialLicense(license)
      };
      this._licenseInfo$.next(mlLicenseUpdate);
      this._license = license;
      this._isSecurityEnabled = mlLicenseUpdate.isSecurityEnabled;
      this._hasLicenseExpired = mlLicenseUpdate.hasLicenseExpired;
      this._isMlEnabled = mlLicenseUpdate.isMlEnabled;
      this._isMinimumLicense = mlLicenseUpdate.isMinimumLicense;
      this._isFullLicense = mlLicenseUpdate.isFullLicense;
      this._isTrialLicense = mlLicenseUpdate.isTrialLicense;
      if (callback !== undefined) {
        callback(this);
      }
    });
  }
  getLicenseInfo() {
    return this._licenseInfo$.getValue();
  }
  unsubscribe() {
    if (this._licenseSubscription !== null) {
      this._licenseSubscription.unsubscribe();
    }
  }
  isSecurityEnabled() {
    return this._isSecurityEnabled;
  }
  hasLicenseExpired() {
    return this._hasLicenseExpired;
  }
  isMlEnabled() {
    return this._isMlEnabled;
  }
  isMinimumLicense() {
    return this._isMinimumLicense;
  }
  isFullLicense() {
    return this._isFullLicense;
  }
  isTrialLicense() {
    return this._isTrialLicense;
  }
}
exports.MlLicense = MlLicense;
function isFullLicense(license) {
  return license.check(_app.PLUGIN_ID, MINIMUM_FULL_LICENSE).state === 'valid';
}
function isTrialLicense(license) {
  return license.check(_app.PLUGIN_ID, TRIAL_LICENSE).state === 'valid';
}
function isMinimumLicense(license) {
  return license.check(_app.PLUGIN_ID, MINIMUM_LICENSE).state === 'valid';
}
function isMlEnabled(license) {
  return license.getFeature(_app.PLUGIN_ID).isEnabled;
}