"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_SEVERITY_COLOR_RAMP = exports.ML_PARTITION_FIELD_VALUE = exports.ML_PARTITION_FIELDS = exports.ML_JOB_ID = exports.ML_ANOMALY_RESULT_TYPE = void 0;
var _anomaly_threshold = require("./anomaly_threshold");
var _severity_colors = require("./severity_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Severity color ramp.
 */
const ML_SEVERITY_COLOR_RAMP = [{
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.LOW,
  color: _severity_colors.ML_SEVERITY_COLORS.WARNING
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR,
  color: _severity_colors.ML_SEVERITY_COLORS.MINOR
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR,
  color: _severity_colors.ML_SEVERITY_COLORS.MAJOR
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL,
  color: _severity_colors.ML_SEVERITY_COLORS.CRITICAL
}];

/**
 * Custom enum for anomaly result type
 */
exports.ML_SEVERITY_COLOR_RAMP = ML_SEVERITY_COLOR_RAMP;
const ML_ANOMALY_RESULT_TYPE = {
  BUCKET: 'bucket',
  RECORD: 'record',
  INFLUENCER: 'influencer'
};

/**
 * Array of partition fields.
 */
exports.ML_ANOMALY_RESULT_TYPE = ML_ANOMALY_RESULT_TYPE;
const ML_PARTITION_FIELDS = ['partition_field', 'over_field', 'by_field'];

/**
 * Machine learning job id attribute name.
 */
exports.ML_PARTITION_FIELDS = ML_PARTITION_FIELDS;
const ML_JOB_ID = 'job_id';

/**
 * Machine learning partition field value attribute name.
 */
exports.ML_JOB_ID = ML_JOB_ID;
const ML_PARTITION_FIELD_VALUE = 'partition_field_value';
exports.ML_PARTITION_FIELD_VALUE = ML_PARTITION_FIELD_VALUE;