"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepwisePagination = StepwisePagination;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiStepwisePagination = (0, _common.euiStyled)(_eui.EuiPagination)`
  [data-test-subj="pagination-button-first"],
  [data-test-subj="pagination-button-last"] {
    display: none;
  }
`;
function StepwisePagination({
  ariaLabel,
  pageCount,
  currentPageIndex,
  setCurrentPageIndex
}) {
  return /*#__PURE__*/_react.default.createElement(EuiStepwisePagination, {
    "aria-label": ariaLabel,
    pageCount: pageCount,
    activePage: currentPageIndex,
    onPageClick: setCurrentPageIndex,
    compressed: true
  });
}