"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTableErrorContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsTableErrorContent = ({
  error
}) => {
  var _error$stack;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      className: "eui-textLeft",
      isCopyable: true,
      language: "jsstacktrace"
    }, (_error$stack = error.stack) !== null && _error$stack !== void 0 ? _error$stack : `${error}`),
    color: "danger",
    "data-test-subj": "metricsTableErrorContent",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, error.message),
    titleSize: "s"
  });
};
exports.MetricsTableErrorContent = MetricsTableErrorContent;