"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoreProviders = ({
  children,
  core,
  theme$
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core);
  return /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, {
    services: {
      ...core
    }
  }, /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, children)));
};
exports.CoreProviders = CoreProviders;