"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeDiskUsed = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeDiskUsed = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.used', {
    defaultMessage: 'Used'
  }),
  value: 'average(kubernetes.node.fs.used.bytes)',
  format: {
    id: 'bytes',
    params: {
      decimals: 1
    }
  }
};
exports.nodeDiskUsed = nodeDiskUsed;