"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskWriteThroughput = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskWriteThroughput = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.diskWriteThroughput', {
    defaultMessage: 'Disk Write Throughput'
  }),
  value: "counter_rate(max(system.diskio.write.bytes), kql='system.diskio.write.bytes: *')",
  format: {
    id: 'bytes',
    params: {
      decimals: 1
    }
  },
  timeScale: 's'
};
exports.diskWriteThroughput = diskWriteThroughput;