"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskIORead = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskIORead = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.diskIORead', {
    defaultMessage: 'Disk Read IOPS'
  }),
  value: "counter_rate(max(system.diskio.read.count), kql='system.diskio.read.count: *')",
  format: {
    id: 'number',
    params: {
      decimals: 0
    }
  },
  timeScale: 's'
};
exports.diskIORead = diskIORead;