"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostsView = void 0;
var _create_dashboard_model = require("../../../create_dashboard_model");
var _charts = require("../charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostsView = {
  get: ({
    metricsDataView
  }) => {
    const commonVisualOptions = {
      showDottedLine: true,
      missingValues: 'Linear'
    };
    const layerOptions = {
      breakdown: {
        type: 'top_values',
        field: 'host.name',
        params: {
          size: 20
        }
      }
    };
    const {
      memoryUsage,
      memoryFree,
      diskUsage,
      diskSpaceAvailable,
      diskIORead,
      diskIOWrite,
      diskReadThroughput,
      diskWriteThroughput,
      rx,
      tx
    } = (0, _charts.createBasicCharts)({
      visualizationType: 'lnsXY',
      formulaIds: ['cpuUsage', 'memoryUsage', 'normalizedLoad1m', 'memoryFree', 'diskUsage', 'diskSpaceAvailable', 'diskIORead', 'diskIOWrite', 'diskReadThroughput', 'diskWriteThroughput', 'rx', 'tx'],
      dataView: metricsDataView,
      layerOptions,
      visualOptions: commonVisualOptions
    });
    const {
      cpuUsage,
      normalizedLoad1m
    } = (0, _charts.createBasicCharts)({
      visualizationType: 'lnsXY',
      formulaIds: ['cpuUsage', 'normalizedLoad1m'],
      layerOptions,
      visualOptions: {
        ...commonVisualOptions,
        yLeftExtent: {
          mode: 'dataBounds',
          lowerBound: 0,
          upperBound: 1
        }
      },
      dataView: metricsDataView
    });
    return (0, _create_dashboard_model.createDashboardModel)({
      charts: [cpuUsage, normalizedLoad1m, memoryUsage, memoryFree, diskUsage, diskSpaceAvailable, diskIORead, diskIOWrite, diskReadThroughput, diskWriteThroughput, rx, tx]
    });
  }
};
exports.hostsView = hostsView;