"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetDetailsFlyout = void 0;
var _create_dashboard_model = require("../../../create_dashboard_model");
var _charts = require("../charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetDetailsFlyout = {
  get: ({
    metricsDataView,
    logsDataView
  }) => {
    const commonVisualOptions = {
      showDottedLine: true,
      missingValues: 'Linear'
    };
    const legend = {
      legend: {
        isVisible: true,
        position: 'bottom'
      }
    };
    const {
      cpuUsage,
      memoryUsage,
      normalizedLoad1m
    } = (0, _charts.createBasicCharts)({
      visualizationType: 'lnsXY',
      formulaIds: ['cpuUsage', 'memoryUsage', 'normalizedLoad1m'],
      dataView: metricsDataView,
      visualOptions: commonVisualOptions
    });
    const {
      logRate
    } = (0, _charts.createBasicCharts)({
      visualizationType: 'lnsXY',
      formulaIds: ['logRate'],
      dataView: logsDataView,
      visualOptions: commonVisualOptions
    });
    return (0, _create_dashboard_model.createDashboardModel)({
      charts: [cpuUsage, memoryUsage, normalizedLoad1m, logRate, {
        ..._charts.diskSpaceUsageAvailable.get({
          dataView: metricsDataView
        }),
        visualOptions: {
          ...commonVisualOptions,
          ...legend
        }
      }, {
        ..._charts.diskUsageByMountPoint.get({
          dataView: metricsDataView
        }),
        visualOptions: {
          ...commonVisualOptions,
          ...legend
        }
      }, {
        ..._charts.diskThroughputReadWrite.get({
          dataView: metricsDataView
        }),
        visualOptions: {
          ...commonVisualOptions,
          ...legend
        }
      }, {
        ..._charts.diskIOReadWrite.get({
          dataView: metricsDataView
        }),
        visualOptions: {
          ...commonVisualOptions,
          ...legend
        }
      }, {
        ..._charts.rxTx.get({
          dataView: metricsDataView
        }),
        visualOptions: {
          ...commonVisualOptions,
          ...legend
        }
      }]
    });
  }
};
exports.assetDetailsFlyout = assetDetailsFlyout;