"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizedLoad1m = exports.loadBreakdown = exports.cpuUsageBreakdown = exports.REFERENCE_LINE = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFERENCE_LINE = {
  value: '1',
  format: {
    id: 'percent',
    params: {
      decimals: 0
    }
  },
  color: '#6092c0'
};
exports.REFERENCE_LINE = REFERENCE_LINE;
const cpuUsageBreakdown = {
  get: ({
    dataView
  }) => ({
    id: 'cpuUsageBreakdown',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.cpuUsage', {
      defaultMessage: 'CPU Usage'
    }),
    layers: [{
      data: [_formulas.formulas.cpuUsageIowait, _formulas.formulas.cpuUsageIrq, _formulas.formulas.cpuUsageNice, _formulas.formulas.cpuUsageSoftirq, _formulas.formulas.cpuUsageSteal, _formulas.formulas.cpuUsageUser, _formulas.formulas.cpuUsageSystem],
      options: {
        seriesType: 'area_stacked'
      },
      layerType: 'data'
    }],
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.cpuUsageBreakdown = cpuUsageBreakdown;
const normalizedLoad1m = {
  get: ({
    dataView
  }) => ({
    id: 'normalizedLoad1m',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.normalizedLoad1m', {
      defaultMessage: 'Normalized Load'
    }),
    layers: [{
      data: [_formulas.formulas.normalizedLoad1m],
      layerType: 'data'
    }, {
      data: [REFERENCE_LINE],
      layerType: 'referenceLine'
    }],
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.normalizedLoad1m = normalizedLoad1m;
const loadBreakdown = {
  get: ({
    dataView
  }) => ({
    id: 'loadBreakdown',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.load', {
      defaultMessage: 'Load'
    }),
    layers: [{
      data: [_formulas.formulas.load1m, _formulas.formulas.load5m, _formulas.formulas.load15m],
      options: {
        seriesType: 'area'
      },
      layerType: 'data'
    }],
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.loadBreakdown = loadBreakdown;