"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupLensChoroplethChart = setupLensChoroplethChart;
var _expression_function = require("./expression_function");
var _expression_renderer = require("./expression_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
function setupLensChoroplethChart(coreSetup, expressions, lens) {
  expressions.registerRenderer(() => {
    return (0, _expression_renderer.getExpressionRenderer)(coreSetup);
  });
  expressions.registerFunction(_expression_function.getExpressionFunction);
  lens.registerVisualization(async () => {
    const [coreStart, plugins] = await coreSetup.getStartServices();
    const {
      getEmsFileLayers
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../util')));
    const {
      getVisualization
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./visualization')));
    let emsFileLayers = [];
    try {
      emsFileLayers = await getEmsFileLayers();
    } catch (error) {
      // eslint-disable-next-line no-console
      console.warn(`Lens region map setup is unable to access administrative boundaries from Elastic Maps Service (EMS). To avoid unnecessary EMS requests, set 'map.includeElasticMapsService: false' in 'kibana.yml'. For more details please visit ${coreStart.docLinks.links.maps.connectToEms}`);
    }
    return getVisualization({
      theme: coreStart.theme,
      emsFileLayers,
      paletteService: await plugins.charts.palettes.getPalettes()
    });
  });
}