"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapDetails = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETAILS_TAB_ID = 'details';
const STYLE_TAB_ID = 'mapStyle';
const TABS = [{
  id: DETAILS_TAB_ID,
  name: _i18n.i18n.translate('xpack.maps.inspector.mapDetailsTitle', {
    defaultMessage: 'Map details'
  }),
  dataTestSubj: 'mapDetailsTab'
}, {
  id: STYLE_TAB_ID,
  name: _i18n.i18n.translate('xpack.maps.inspector.mapboxStyleTitle', {
    defaultMessage: 'Mapbox style'
  }),
  dataTestSubj: 'mapboxStyleTab'
}];
class MapDetails extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      selectedTabId: DETAILS_TAB_ID
    });
    (0, _defineProperty2.default)(this, "onSelectedTabChanged", id => {
      this.setState({
        selectedTabId: id
      });
    });
    (0, _defineProperty2.default)(this, "renderTab", () => {
      if (STYLE_TAB_ID === this.state.selectedTabId) {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "mapboxStyleContainer"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          paddingSize: "s"
        }, JSON.stringify(this.props.style, null, 2)));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
        style: {
          tableLayout: 'auto'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.centerLonLabel",
        defaultMessage: "Center lon"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "centerLon"
      }, this.props.centerLon)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.centerLatLabel",
        defaultMessage: "Center lat"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "centerLat"
      }, this.props.centerLat)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.inspector.zoomLabel",
        defaultMessage: "Zoom"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        "data-test-subj": "zoom"
      }, this.props.zoom))));
    });
  }
  renderTabs() {
    return TABS.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => this.onSelectedTabChanged(tab.id),
      isSelected: tab.id === this.state.selectedTabId,
      key: index,
      "data-test-subj": tab.dataTestSubj
    }, tab.name));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, this.renderTabs()), this.renderTab());
  }
}
exports.MapDetails = MapDetails;