"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsControl = void 0;
var _reactRedux = require("react-redux");
var _tools_control = require("./tools_control");
var _actions = require("../../../actions");
var _constants = require("../../../../common/constants");
var _ui_selectors = require("../../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  const drawMode = (0, _ui_selectors.getDrawMode)(state);
  return {
    filterModeActive: drawMode === _constants.DRAW_MODE.DRAW_FILTERS
  };
}
function mapDispatchToProps(dispatch) {
  return {
    cancelDraw: () => {
      dispatch((0, _actions.updateDrawState)(null));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.NONE));
    },
    initiateDraw: drawState => {
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.DRAW_FILTERS));
      dispatch((0, _actions.updateDrawState)(drawState));
    }
  };
}
const connectedToolsControl = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_tools_control.ToolsControl);
exports.ToolsControl = connectedToolsControl;