"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetViewControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _set_view_form = require("./set_view_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SetViewControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", (lat, lon, zoom) => {
      this._closePopover();
      this.props.onSubmit({
        lat,
        lon,
        zoom
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "leftUp",
      panelPaddingSize: "s",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "none",
        className: "mapToolbarOverlay__button"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        className: "mapToolbarOverlay__buttonIcon-empty",
        size: "s",
        onClick: this._togglePopover,
        "data-test-subj": "toggleSetViewVisibilityButton",
        iconType: "crosshairs",
        color: "text",
        "aria-label": _i18n.i18n.translate('xpack.maps.setViewControl.goToButtonLabel', {
          defaultMessage: 'Go to'
        }),
        title: _i18n.i18n.translate('xpack.maps.setViewControl.goToButtonLabel', {
          defaultMessage: 'Go to'
        })
      })),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover
    }, /*#__PURE__*/_react.default.createElement(_set_view_form.SetViewForm, {
      settings: this.props.settings,
      zoom: this.props.zoom,
      center: this.props.center,
      onSubmit: this._onSubmit
    }));
  }
}
exports.SetViewControl = SetViewControl;