"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MouseCoordinatesControl = void 0;
var _reactRedux = require("react-redux");
var _mouse_coordinates_control = require("./mouse_coordinates_control");
var _map_selectors = require("../../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    mouseCoordinates: (0, _map_selectors.getMouseCoordinates)(state),
    zoom: (0, _map_selectors.getMapZoom)(state)
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, {})(_mouse_coordinates_control.MouseCoordinatesControl);
exports.MouseCoordinatesControl = connected;