"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRequest = transformRequest;
var _coreHttpCommon = require("@kbn/core-http-common");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FONTS = (0, _kibana_services.getHttp)().basePath.prepend(_constants.FONTS_API_PATH);
const GETTILE = (0, _kibana_services.getHttp)().basePath.prepend(_constants.MVT_GETTILE_API_PATH);
const GETGRIDTILE = (0, _kibana_services.getHttp)().basePath.prepend(_constants.MVT_GETGRIDTILE_API_PATH);
function transformRequest(url, resourceType) {
  if (resourceType === 'Glyphs' && url.startsWith(FONTS)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  if (resourceType === 'Tile' && url.startsWith(GETTILE)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  if (resourceType === 'Tile' && url.startsWith(GETGRIDTILE)) {
    return {
      url,
      method: 'GET',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1',
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'kibana'
      }
    };
  }
  return {
    url
  };
}