"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipControl = void 0;
var _reactRedux = require("react-redux");
var _tooltip_control = require("./tooltip_control");
var _actions = require("../../../actions");
var _map_selectors = require("../../../selectors/map_selectors");
var _ui_selectors = require("../../../selectors/ui_selectors");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    layerList: (0, _map_selectors.getLayerList)(state),
    hasLockedTooltips: (0, _map_selectors.getHasLockedTooltips)(state),
    filterModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_FILTERS,
    drawModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_SHAPES || (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_POINTS,
    openTooltips: (0, _map_selectors.getOpenTooltips)(state),
    geoFieldNames: (0, _map_selectors.getGeoFieldNames)(state),
    executionContext: (0, _map_selectors.getExecutionContext)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    closeOnClickTooltip(tooltipId) {
      dispatch((0, _actions.closeOnClickTooltip)(tooltipId));
    },
    openOnClickTooltip(tooltipState) {
      dispatch((0, _actions.openOnClickTooltip)(tooltipState));
    },
    closeOnHoverTooltip() {
      dispatch((0, _actions.closeOnHoverTooltip)());
    },
    openOnHoverTooltip(tooltipState) {
      dispatch((0, _actions.openOnHoverTooltip)(tooltipState));
    },
    updateOpenTooltips(openTooltips) {
      dispatch((0, _actions.updateOpenTooltips)(openTooltips));
    }
  };
}
const connectedTooltipControl = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_tooltip_control.TooltipControl);
exports.TooltipControl = connectedTooltipControl;