"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIconsPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
var _symbol_icon = require("../../classes/styles/vector/components/legend/symbol_icon");
var _custom_icon_modal = require("../../classes/styles/vector/components/symbol/custom_icon_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CustomIconsPanel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalVisible: false,
      selectedIcon: undefined
    });
    (0, _defineProperty2.default)(this, "_handleIconEdit", icon => {
      this.setState({
        selectedIcon: icon,
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "_handleNewIcon", () => {
      this.setState({
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "_renderModal", () => {
      if (!this.state.isModalVisible) {
        return null;
      }
      if (this.state.selectedIcon) {
        const {
          symbolId,
          label,
          svg,
          cutoff,
          radius
        } = this.state.selectedIcon;
        return /*#__PURE__*/_react.default.createElement(_custom_icon_modal.CustomIconModal, {
          title: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.editCustomIcon', {
            defaultMessage: 'Edit custom icon'
          }),
          symbolId: symbolId,
          label: label,
          svg: svg,
          cutoff: cutoff || _constants.DEFAULT_CUSTOM_ICON_CUTOFF,
          radius: radius || _constants.DEFAULT_CUSTOM_ICON_RADIUS,
          onSave: this._handleSave,
          onCancel: this._hideModal,
          onDelete: this._handleDelete
        });
      }
      return /*#__PURE__*/_react.default.createElement(_custom_icon_modal.CustomIconModal, {
        title: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.addCustomIcon', {
          defaultMessage: 'Add custom icon'
        }),
        cutoff: _constants.DEFAULT_CUSTOM_ICON_CUTOFF,
        radius: _constants.DEFAULT_CUSTOM_ICON_RADIUS,
        onSave: this._handleSave,
        onCancel: this._hideModal
      });
    });
    (0, _defineProperty2.default)(this, "_hideModal", () => {
      this.setState({
        isModalVisible: false,
        selectedIcon: undefined
      });
    });
    (0, _defineProperty2.default)(this, "_handleSave", icon => {
      const {
        symbolId,
        label,
        svg,
        cutoff,
        radius
      } = icon;
      const icons = [...this.props.customIcons.filter(i => {
        return i.symbolId !== symbolId;
      }), {
        symbolId,
        svg,
        label,
        cutoff,
        radius
      }];
      this.props.updateCustomIcons(icons);
      this._hideModal();
    });
    (0, _defineProperty2.default)(this, "_handleDelete", symbolId => {
      this.props.deleteCustomIcon(symbolId);
      this._hideModal();
    });
    (0, _defineProperty2.default)(this, "_renderCustomIconsList", () => {
      const addIconButton = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
        textAlign: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "plusInCircleFilled",
        onClick: () => this._handleNewIcon(),
        "data-test-subj": "mapsCustomIconPanel-add"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.mapSettingsPanel.customIconsAddIconButton",
        defaultMessage: "Add"
      }))));
      if (!this.props.customIcons.length) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          textAlign: "center"
        }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.maps.mapSettingsPanel.customIcons.emptyState.description",
          defaultMessage: "Add a custom icon that can be used in layers in this map."
        })))), addIconButton);
      }
      const customIconsList = this.props.customIcons.map(icon => {
        const {
          symbolId,
          label,
          svg
        } = icon;
        return {
          label,
          key: symbolId,
          icon: /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
            symbolId: label,
            svg: svg,
            fill: (0, _kibana_services.getIsDarkMode)() ? 'rgb(223, 229, 239)' : 'rgb(52, 55, 65)'
          }),
          extraAction: {
            iconType: 'gear',
            alwaysShow: true,
            onClick: () => {
              this._handleIconEdit(icon);
            }
          }
        };
      });
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
        listItems: customIconsList
      }), addIconButton);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mapSettingsPanel.customIconsTitle",
      defaultMessage: "Custom icons"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this._renderCustomIconsList()), this._renderModal());
  }
}
exports.CustomIconsPanel = CustomIconsPanel;