"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("../../_index.scss");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _mb_map = require("../mb_map");
var _right_side_controls = require("../right_side_controls");
var _timeslider = require("../timeslider");
var _toolbar_overlay = require("../toolbar_overlay");
var _edit_layer_panel = require("../edit_layer_panel");
var _add_layer_panel = require("../add_layer_panel");
var _kibana_services = require("../../kibana_services");
var _constants = require("../../../common/constants");
var _ui = require("../../reducers/ui");
var _map_settings_panel = require("../map_settings_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RENDER_COMPLETE_EVENT = 'renderComplete';
class MapContainer extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_isInitalLoadRenderTimerStarted", false);
    (0, _defineProperty2.default)(this, "state", {
      isInitialLoadRenderTimeoutComplete: false,
      domId: (0, _uuid.v4)(),
      showFitToBoundsButton: false,
      showTimesliderButton: false
    });
    // Reporting uses both a `data-render-complete` attribute and a DOM event listener to determine
    // if a visualization is done loading. The process roughly is:
    // - See if the `data-render-complete` attribute is "true". If so we're done!
    // - If it's not, then reporting injects a listener into the browser for a custom "renderComplete" event.
    // - When that event is fired, we snapshot the viz and move on.
    // Failure to not have the dom attribute, or custom event, will timeout the job.
    // See x-pack/plugins/reporting/export_types/common/lib/screenshots/wait_for_render.ts for more.
    (0, _defineProperty2.default)(this, "_onInitialLoadRenderComplete", () => {
      const el = document.querySelector(`[data-dom-id="${this.state.domId}"]`);
      if (el) {
        el.dispatchEvent(new CustomEvent(RENDER_COMPLETE_EVENT, {
          bubbles: true
        }));
      }
    });
    (0, _defineProperty2.default)(this, "_startInitialLoadRenderTimer", () => {
      window.setTimeout(() => {
        if (this._isMounted) {
          this.setState({
            isInitialLoadRenderTimeoutComplete: true
          });
          this._onInitialLoadRenderComplete();
        }
      }, _constants.RENDER_TIMEOUT);
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadShowFitToBoundsButton();
    this._loadShowTimesliderButton();
  }
  componentDidUpdate() {
    this._loadShowFitToBoundsButton();
    this._loadShowTimesliderButton();
    if (this.props.isSharable && !this.props.isMapLoading && !this._isInitalLoadRenderTimerStarted) {
      this._isInitalLoadRenderTimerStarted = true;
      this._startInitialLoadRenderTimer();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.cancelAllInFlightRequests();
  }
  async _loadShowFitToBoundsButton() {
    const promises = this.props.layerList.map(async layer => {
      return await layer.isFittable();
    });
    const showFitToBoundsButton = (await Promise.all(promises)).some(isFittable => isFittable);
    if (this._isMounted && this.state.showFitToBoundsButton !== showFitToBoundsButton) {
      this.setState({
        showFitToBoundsButton
      });
    }
  }
  async _loadShowTimesliderButton() {
    if (!this.props.settings.showTimesliderToggleButton) {
      if (this.state.showTimesliderButton) {
        this.setState({
          showTimesliderButton: false
        });
      }
      return;
    }
    const promises = this.props.layerList.map(async layer => {
      return await layer.isFilteredByGlobalTime();
    });
    const showTimesliderButton = (await Promise.all(promises)).some(isFilteredByGlobalTime => isFilteredByGlobalTime);
    if (this._isMounted && this.state.showTimesliderButton !== showTimesliderButton) {
      this.setState({
        showTimesliderButton
      });
    }
  }
  render() {
    const {
      addFilters,
      getFilterActions,
      getActionContext,
      onSingleValueTrigger,
      flyoutDisplay,
      isFullScreen,
      exitFullScreen,
      mapInitError,
      renderTooltipContent
    } = this.props;
    if (mapInitError) {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-render-complete": true,
        "data-shared-item": true,
        "data-title": this.props.title,
        "data-description": this.props.description
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.maps.map.initializeErrorTitle', {
          defaultMessage: 'Unable to initialize map'
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/_react.default.createElement("p", null, mapInitError)));
    }
    let flyoutPanel = null;
    if (flyoutDisplay === _ui.FLYOUT_STATE.ADD_LAYER_WIZARD) {
      flyoutPanel = /*#__PURE__*/_react.default.createElement(_add_layer_panel.AddLayerPanel, null);
    } else if (flyoutDisplay === _ui.FLYOUT_STATE.LAYER_PANEL) {
      flyoutPanel = /*#__PURE__*/_react.default.createElement(_edit_layer_panel.EditLayerPanel, null);
    } else if (flyoutDisplay === _ui.FLYOUT_STATE.MAP_SETTINGS_PANEL) {
      flyoutPanel = /*#__PURE__*/_react.default.createElement(_map_settings_panel.MapSettingsPanel, null);
    }
    let exitFullScreenButton;
    if (isFullScreen) {
      exitFullScreenButton = /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButton, {
        onExit: exitFullScreen
      });
    }
    const shareAttributes = this.props.isSharable ? {
      ['data-dom-id']: this.state.domId,
      ['data-render-complete']: this.state.isInitialLoadRenderTimeoutComplete,
      ['data-shared-item']: true,
      ['data-title']: this.props.title,
      ['data-description']: this.props.description
    } : {};
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
      gutterSize: "none",
      responsive: false
    }, shareAttributes), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "mapMapWrapper",
      style: {
        backgroundColor: this.props.settings.backgroundColor
      }
    }, /*#__PURE__*/_react.default.createElement(_mb_map.MBMap, {
      addFilters: addFilters,
      getFilterActions: getFilterActions,
      getActionContext: getActionContext,
      onSingleValueTrigger: onSingleValueTrigger,
      renderTooltipContent: renderTooltipContent
    }), !this.props.settings.hideToolbarOverlay && !(0, _kibana_services.isScreenshotMode)() && /*#__PURE__*/_react.default.createElement(_toolbar_overlay.ToolbarOverlay, {
      addFilters: addFilters,
      getFilterActions: getFilterActions,
      getActionContext: getActionContext,
      showFitToBoundsButton: this.state.showFitToBoundsButton,
      showTimesliderButton: this.state.showTimesliderButton
    }), /*#__PURE__*/_react.default.createElement(_right_side_controls.RightSideControls, null), this.props.isTimesliderOpen && /*#__PURE__*/_react.default.createElement(_timeslider.Timeslider, {
      waitForTimesliceToLoad$: this.props.waitUntilTimeLayersLoad$
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: (0, _classnames.default)('mapMapLayerPanel', {
        'mapMapLayerPanel-isVisible': !!flyoutPanel
      }),
      grow: false
    }, flyoutPanel), exitFullScreenButton);
  }
}
exports.MapContainer = MapContainer;