"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyleSettings = void 0;
var _reactRedux = require("react-redux");
var _style_settings = require("./style_settings");
var _map_selectors = require("../../../selectors/map_selectors");
var _actions = require("../../../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    layer: (0, _map_selectors.getSelectedLayer)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    updateStyleDescriptor: styleDescriptor => {
      dispatch((0, _actions.updateLayerStyleForSelectedLayer)(styleDescriptor));
    },
    updateCustomIcons: customIcons => {
      dispatch((0, _actions.updateCustomIcons)(customIcons));
    }
  };
}
const connectedStyleSettings = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_style_settings.StyleSettings);
exports.StyleSettings = connectedStyleSettings;