"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermJoinExpression = TermJoinExpression;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _term_join_popover_content = require("./term_join_popover_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TermJoinExpression(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    size,
    term
  } = props.sourceDescriptor;
  const expressionValue = term !== undefined ? _i18n.i18n.translate('xpack.maps.termJoinExpression.value', {
    defaultMessage: '{topTerms} terms from {term}',
    values: {
      topTerms: size !== undefined ? _i18n.i18n.translate('xpack.maps.termJoinExpression.topTerms', {
        defaultMessage: 'top {size}',
        values: {
          size
        }
      }) : '',
      term
    }
  }) : _i18n.i18n.translate('xpack.maps.termJoinExpression.placeholder', {
    defaultMessage: '-- configure term join --'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: props.sourceDescriptor.id,
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    ownFocus: true,
    initialFocus: "body" /* avoid initialFocus on Combobox */,
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      description: _i18n.i18n.translate('xpack.maps.termJoinExpression.description', {
        defaultMessage: 'Join with'
      }),
      uppercase: false,
      value: expressionValue
    }),
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_term_join_popover_content.TermJoinPopoverContent, {
    leftSourceName: props.leftSourceName,
    leftValue: props.leftValue,
    leftFields: props.leftFields,
    onLeftFieldChange: props.onLeftFieldChange,
    sourceDescriptor: props.sourceDescriptor,
    onSourceDescriptorChange: props.onSourceDescriptorChange,
    rightFields: props.rightFields
  }));
}