"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrdinalLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _ranged_style_legend_row = require("../../../../components/ranged_style_legend_row");
var _constants = require("../../../../../../../common/constants");
var _circle_icon = require("../circle_icon");
var _get_ordinal_label = require("./get_ordinal_label");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLineWidthIcons() {
  const defaultStyle = {
    stroke: 'grey',
    fill: 'none',
    width: '12px'
  };
  return [/*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '1px'
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '2px'
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '3px'
    }
  })];
}
function getSymbolSizeIcons() {
  const defaultStyle = {
    stroke: 'grey',
    fill: 'grey'
  };
  return [/*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '8px'
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '12px'
    }
  })];
}
const EMPTY_VALUE = '';
class OrdinalLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: EMPTY_VALUE
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const field = this.props.style.getField();
    if (!field) {
      return;
    }
    const label = await field.getLabel();
    if (this._isMounted && !_lodash.default.isEqual(this.state.label, label)) {
      this.setState({
        label
      });
    }
  }
  _formatValue(value) {
    if (value === EMPTY_VALUE) {
      return value;
    }
    return this.props.style.formatField(value);
  }
  _renderRangeLegendHeader() {
    let icons;
    if (this.props.style.getStyleName() === _constants.VECTOR_STYLES.LINE_WIDTH) {
      icons = getLineWidthIcons();
    } else if (this.props.style.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE) {
      icons = getSymbolSizeIcons();
    } else {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, icons.map((icon, index) => {
      const isLast = index === icons.length - 1;
      let spacer;
      if (!isLast) {
        spacer = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "xs"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, icon), spacer);
    }));
  }
  render() {
    const header = this._renderRangeLegendHeader();
    if (!header) {
      return null;
    }
    const fieldMeta = this.props.style.getRangeFieldMeta();
    let minLabel = EMPTY_VALUE;
    let maxLabel = EMPTY_VALUE;
    if (fieldMeta) {
      const min = this._formatValue(_lodash.default.get(fieldMeta, 'min', EMPTY_VALUE));
      minLabel = (0, _get_ordinal_label.getMinLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMinOutsideStdRange), min);
      const max = this._formatValue(_lodash.default.get(fieldMeta, 'max', EMPTY_VALUE));
      maxLabel = (0, _get_ordinal_label.getMaxLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMaxOutsideStdRange), max);
    }
    const options = this.props.style.getOptions();
    const invert = options.invert === undefined ? false : options.invert;
    return /*#__PURE__*/_react.default.createElement(_ranged_style_legend_row.RangedStyleLegendRow, {
      header: header,
      minLabel: minLabel,
      maxLabel: maxLabel,
      propertyLabel: this.props.style.getDisplayStyleName(),
      fieldLabel: this.state.label,
      invert: invert
    });
  }
}
exports.OrdinalLegend = OrdinalLegend;