"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NUMERICAL_COLOR_PALETTES = exports.DEFAULT_LINE_COLORS = exports.DEFAULT_HEATMAP_COLOR_RAMP_NAME = exports.DEFAULT_FILL_COLORS = exports.CATEGORICAL_COLOR_PALETTES = void 0;
exports.getColorPalette = getColorPalette;
exports.getColorRampCenterColor = getColorRampCenterColor;
exports.getLinearGradient = getLinearGradient;
exports.getOrdinalMbColorRampStops = getOrdinalMbColorRampStops;
exports.getPercentilesMbColorRampStops = getPercentilesMbColorRampStops;
var _tinycolor = _interopRequireDefault(require("tinycolor2"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_HEATMAP_COLOR_RAMP_NAME = 'theclassic';
exports.DEFAULT_HEATMAP_COLOR_RAMP_NAME = DEFAULT_HEATMAP_COLOR_RAMP_NAME;
const DEFAULT_FILL_COLORS = (0, _eui.euiPaletteColorBlind)();
exports.DEFAULT_FILL_COLORS = DEFAULT_FILL_COLORS;
const DEFAULT_LINE_COLORS = [...DEFAULT_FILL_COLORS.map(color => (0, _tinycolor.default)(color).darken().toHexString()),
// Explicitly add black & white as border color options
'#000', '#FFF'];
exports.DEFAULT_LINE_COLORS = DEFAULT_LINE_COLORS;
const ROYAL_BLUE = 'rgb(65, 105, 225)';
const CYAN = 'rgb(0, 256, 256)';
const LIME = 'rgb(0, 256, 0)';
const YELLOW = 'rgb(256, 256, 0)';
const RED = 'rgb(256, 0, 0)';
const HEATMAP_PALETTE = [ROYAL_BLUE, CYAN, LIME, YELLOW, RED];
function getColorBlindPalette(steps) {
  const rotations = Math.ceil(steps / 10);
  const palette = (0, _eui.euiPaletteColorBlind)({
    rotations
  });
  return palette.slice(0, steps - 1);
}
const COLOR_PALETTES = [{
  value: 'Blues',
  getPalette: steps => {
    return (0, _eui.euiPaletteCool)(steps);
  },
  palette: (0, _eui.euiPaletteCool)(8),
  type: 'gradient'
}, {
  value: 'Greens',
  getPalette: steps => {
    return (0, _eui.euiPalettePositive)(steps);
  },
  palette: (0, _eui.euiPalettePositive)(8),
  type: 'gradient'
}, {
  value: 'Greys',
  getPalette: steps => {
    return (0, _eui.euiPaletteGray)(steps);
  },
  palette: (0, _eui.euiPaletteGray)(8),
  type: 'gradient'
}, {
  value: 'Reds',
  getPalette: steps => {
    return (0, _eui.euiPaletteNegative)(steps);
  },
  palette: (0, _eui.euiPaletteNegative)(8),
  type: 'gradient'
}, {
  value: 'Yellow to Red',
  getPalette: steps => {
    return (0, _eui.euiPaletteWarm)(steps);
  },
  palette: (0, _eui.euiPaletteWarm)(8),
  type: 'gradient'
}, {
  value: 'Green to Red',
  getPalette: steps => {
    return (0, _eui.euiPaletteForStatus)(steps);
  },
  palette: (0, _eui.euiPaletteForStatus)(8),
  type: 'gradient'
}, {
  value: 'Blue to Red',
  getPalette: steps => {
    return (0, _eui.euiPaletteForTemperature)(steps);
  },
  palette: (0, _eui.euiPaletteForTemperature)(8),
  type: 'gradient'
}, {
  value: DEFAULT_HEATMAP_COLOR_RAMP_NAME,
  getPalette: steps => {
    return (0, _eui.colorPalette)(HEATMAP_PALETTE, steps, true, true);
  },
  palette: HEATMAP_PALETTE,
  type: 'gradient'
}, {
  value: 'palette_0',
  getPalette: getColorBlindPalette,
  palette: (0, _eui.euiPaletteColorBlind)(),
  type: 'fixed'
}, {
  value: 'palette_20',
  getPalette: getColorBlindPalette,
  palette: (0, _eui.euiPaletteColorBlind)({
    rotations: 2
  }),
  type: 'fixed'
}, {
  value: 'palette_30',
  getPalette: getColorBlindPalette,
  palette: (0, _eui.euiPaletteColorBlind)({
    rotations: 3
  }),
  type: 'fixed'
}];
const NUMERICAL_COLOR_PALETTES = COLOR_PALETTES.filter(palette => {
  return palette.type === 'gradient';
});
exports.NUMERICAL_COLOR_PALETTES = NUMERICAL_COLOR_PALETTES;
const CATEGORICAL_COLOR_PALETTES = COLOR_PALETTES.filter(palette => {
  return palette.type === 'fixed';
});
exports.CATEGORICAL_COLOR_PALETTES = CATEGORICAL_COLOR_PALETTES;
function getColorPalette(colorPaletteId) {
  const colorPalette = COLOR_PALETTES.find(({
    value
  }) => {
    return value === colorPaletteId;
  });
  return colorPalette ? [...colorPalette.palette] : [];
}
function getColorRampCenterColor(colorPaletteId) {
  if (!colorPaletteId) {
    return null;
  }
  const palette = getColorPalette(colorPaletteId);
  return palette.length === 0 ? null : palette[Math.floor(palette.length / 2)];
}

// Returns an array of color stops
// [ stop_input_1: number, stop_output_1: color, stop_input_n: number, stop_output_n: color ]
function getOrdinalMbColorRampStops(colorPaletteId, min, max, invert) {
  if (!colorPaletteId) {
    return null;
  }
  if (min > max) {
    return null;
  }
  const palette = getColorPalette(colorPaletteId);
  if (invert) {
    palette.reverse();
  }
  if (palette.length === 0) {
    return null;
  }
  if (max === min) {
    // just return single stop value
    return [max, palette[palette.length - 1]];
  }
  const delta = max - min;
  return palette.reduce((accu, stopColor, idx, srcArr) => {
    const stopNumber = min + delta * idx / srcArr.length;
    accu.push(stopNumber, stopColor);
    return accu;
  }, []);
}

// Returns an array of color stops
// [ stop_input_1: number, stop_output_1: color, stop_input_n: number, stop_output_n: color ]
function getPercentilesMbColorRampStops(colorPaletteId, percentiles, invert) {
  if (!colorPaletteId) {
    return null;
  }
  const paletteObject = NUMERICAL_COLOR_PALETTES.find(({
    value
  }) => {
    return value === colorPaletteId;
  });
  if (!paletteObject) {
    return null;
  }
  const palette = paletteObject.getPalette(percentiles.length);
  if (invert) {
    palette.reverse();
  }
  return palette.reduce((accu, stopColor, idx) => {
    accu.push(percentiles[idx].value, stopColor);
    return accu;
  }, []);
}
function getLinearGradient(colorStrings) {
  const intervals = colorStrings.length;
  let linearGradient = `linear-gradient(to right, ${colorStrings[0]} 0%,`;
  for (let i = 1; i < intervals - 1; i++) {
    linearGradient = `${linearGradient} ${colorStrings[i]} \
      ${Math.floor(100 * i / (intervals - 1))}%,`;
  }
  return `${linearGradient} ${colorStrings[colorStrings.length - 1]} 100%)`;
}