"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSources = setupSources;
var _constants = require("../../../common/constants");
var _source_registry = require("./source_registry");
var _ems_file_source = require("./ems_file_source");
var _ems_tms_source = require("./ems_tms_source");
var _es_geo_grid_source = require("./es_geo_grid_source");
var _es_geo_line_source = require("./es_geo_line_source");
var _es_pew_pew_source = require("./es_pew_pew_source");
var _es_search_source = require("./es_search_source");
var _geojson_file_source = require("./geojson_file_source");
var _kibana_tilemap_source = require("./kibana_tilemap_source");
var _mvt_single_layer_vector_source = require("./mvt_single_layer_vector_source");
var _wms_source = require("./wms_source");
var _xyz_tms_source = require("./xyz_tms_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let registered = false;
function setupSources() {
  if (registered) {
    return;
  }
  (0, _source_registry.registerSource)({
    ConstructorFunction: _ems_file_source.EMSFileSource,
    type: _constants.SOURCE_TYPES.EMS_FILE
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _ems_tms_source.EMSTMSSource,
    type: _constants.SOURCE_TYPES.EMS_TMS
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _es_geo_grid_source.ESGeoGridSource,
    type: _constants.SOURCE_TYPES.ES_GEO_GRID
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _es_geo_line_source.ESGeoLineSource,
    type: _constants.SOURCE_TYPES.ES_GEO_LINE
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _es_pew_pew_source.ESPewPewSource,
    type: _constants.SOURCE_TYPES.ES_PEW_PEW
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _es_search_source.ESSearchSource,
    type: _constants.SOURCE_TYPES.ES_SEARCH
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _geojson_file_source.GeoJsonFileSource,
    type: _constants.SOURCE_TYPES.GEOJSON_FILE
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _kibana_tilemap_source.KibanaTilemapSource,
    type: _constants.SOURCE_TYPES.KIBANA_TILEMAP
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _mvt_single_layer_vector_source.MVTSingleLayerVectorSource,
    type: _constants.SOURCE_TYPES.MVT_SINGLE_LAYER
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _wms_source.WMSSource,
    type: _constants.SOURCE_TYPES.WMS
  });
  (0, _source_registry.registerSource)({
    ConstructorFunction: _xyz_tms_source.XYZTMSSource,
    type: _constants.SOURCE_TYPES.EMS_XYZ
  });
  registered = true;
}