"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopHitsUpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _constants = require("../../../../../common/constants");
var _tooltip_selector = require("../../../../components/tooltip_selector");
var _kibana_services = require("../../../../kibana_services");
var _index_pattern_util = require("../../../../index_pattern_util");
var _es_doc_field = require("../../../fields/es_doc_field");
var _top_hits_form = require("./top_hits_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TopHitsUpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false,
      isTimeseries: false,
      sourceFields: [],
      termFields: [],
      sortFields: []
    });
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesChange", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_onFilterByMapBoundsChange", event => {
      this.props.onChange({
        propName: 'filterByMapBounds',
        value: event.target.checked
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadFields() {
    this.setState({
      isLoading: true
    });
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          isLoading: false,
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(this.props.indexPatternId)
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }
    const rawTooltipFields = (0, _index_pattern_util.getSourceFields)(indexPattern.fields);
    const sourceFields = rawTooltipFields.map(field => {
      return new _es_doc_field.ESDocField({
        fieldName: field.name,
        source: this.props.source,
        origin: _constants.FIELD_ORIGIN.SOURCE
      });
    });
    this.setState({
      isLoading: false,
      isTimeseries: (0, _index_pattern_util.getIsTimeseries)(indexPattern),
      sourceFields,
      termFields: (0, _index_pattern_util.getTermsFields)(indexPattern.fields),
      sortFields: (0, _index_pattern_util.getSortFields)(indexPattern.fields)
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.tooltipsTitle",
      defaultMessage: "Tooltip fields"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      size: "s",
      isLoading: this.state.isLoading
    }, /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields,
      onChange: this._onTooltipPropertiesChange,
      fields: this.state.sourceFields
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.topHitsPanelLabel",
      defaultMessage: "Top hits"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      size: "s",
      isLoading: this.state.isLoading
    }, /*#__PURE__*/_react.default.createElement(_top_hits_form.TopHitsForm, {
      indexPatternId: this.props.indexPatternId,
      isColumnCompressed: true,
      isTimeseries: this.state.isTimeseries,
      onChange: this.props.onChange,
      sortField: this.props.sortField,
      sortFields: this.state.sortFields,
      sortOrder: this.props.sortOrder,
      termFields: this.state.termFields,
      topHitsGroupByTimeseries: this.props.topHitsGroupByTimeseries,
      topHitsSplitField: this.props.topHitsSplitField,
      topHitsSize: this.props.topHitsSize
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.extentFilterLabel', {
        defaultMessage: 'Dynamically filter for data in the visible map area'
      }),
      checked: this.props.filterByMapBounds,
      onChange: this._onFilterByMapBoundsChange,
      compressed: true
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
}
exports.TopHitsUpdateSourceEditor = TopHitsUpdateSourceEditor;