"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggDisplayName = getAggDisplayName;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAggDisplayName(aggType) {
  switch (aggType) {
    case _constants.AGG_TYPE.AVG:
      return _i18n.i18n.translate('xpack.maps.aggType.averageLabel', {
        defaultMessage: 'average'
      });
    case _constants.AGG_TYPE.COUNT:
      return _i18n.i18n.translate('xpack.maps.aggType.countLabel', {
        defaultMessage: 'count'
      });
    case _constants.AGG_TYPE.MAX:
      return _i18n.i18n.translate('xpack.maps.aggType.maximumLabel', {
        defaultMessage: 'max'
      });
    case _constants.AGG_TYPE.MIN:
      return _i18n.i18n.translate('xpack.maps.aggType.minimumLabel', {
        defaultMessage: 'min'
      });
    case _constants.AGG_TYPE.PERCENTILE:
      return _i18n.i18n.translate('xpack.maps.aggType.percentileLabel', {
        defaultMessage: 'percentile'
      });
    case _constants.AGG_TYPE.SUM:
      return _i18n.i18n.translate('xpack.maps.aggType.sumLabel', {
        defaultMessage: 'sum'
      });
    case _constants.AGG_TYPE.TERMS:
      return _i18n.i18n.translate('xpack.maps.aggType.topTermLabel', {
        defaultMessage: 'top term'
      });
    case _constants.AGG_TYPE.UNIQUE_COUNT:
      return _i18n.i18n.translate('xpack.maps.aggType.cardinalityTermLabel', {
        defaultMessage: 'unique count'
      });
    default:
      return aggType;
  }
}