"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationshipExpression = RelationshipExpression;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _distance_form = require("./distance_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RelationshipExpression(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  function closePopover() {
    setIsPopoverOpen(false);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "spatialJoinRelationship",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      color: "subdued",
      description: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.withinExpressionDescription', {
        defaultMessage: 'within'
      }),
      value: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.withinExpressionValue', {
        defaultMessage: '{distance} {units} of layer features',
        values: {
          distance: props.distance,
          units: _distance_form.KM_ABBREVIATION
        }
      }),
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      uppercase: false
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "s",
    anchorPosition: "downCenter",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_distance_form.DistanceForm, {
    initialDistance: props.distance,
    onDistanceChange: props.onDistanceChange,
    onClose: closePopover
  }));
}