"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileErrorsList = TileErrorsList;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TileErrorsList(props) {
  const [selectedTileError, setSelectedTileError] = (0, _react.useState)(undefined);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const hasSelectedTileError = selectedTileError && props.tileErrors.some(({
      tileKey
    }) => {
      return tileKey === selectedTileError.tileKey;
    });
    if (!hasSelectedTileError) {
      var _props$tileErrors;
      setSelectedTileError((_props$tileErrors = props.tileErrors) === null || _props$tileErrors === void 0 ? void 0 : _props$tileErrors[0]);
    }
  }, [props.tileErrors, selectedTileError]);
  if (props.tileErrors.length === 0 || !selectedTileError) {
    return null;
  }
  const panels = [{
    id: 0,
    items: props.tileErrors.map(tileError => {
      return {
        name: getTitle(tileError.tileKey),
        onClick: () => {
          const nextTileError = props.tileErrors.find(({
            tileKey
          }) => {
            return tileKey === tileError.tileKey;
          });
          setSelectedTileError(nextTileError);
          setIsPopoverOpen(false);
        }
      };
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "tileErrorsPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      size: "s"
    }, getTitle(selectedTileError.tileKey)),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("p", null, getDescription(selectedTileError)));
}
function getTitle(tileKey) {
  return _i18n.i18n.translate('xpack.maps.tileError.title', {
    defaultMessage: `tile {tileKey}`,
    values: {
      tileKey
    }
  });
}
function getDescription(tileError) {
  var _tileError$error, _tileError$error$root, _tileError$error$root2, _tileError$error2;
  if ((_tileError$error = tileError.error) !== null && _tileError$error !== void 0 && (_tileError$error$root = _tileError$error.root_cause) !== null && _tileError$error$root !== void 0 && (_tileError$error$root2 = _tileError$error$root[0]) !== null && _tileError$error$root2 !== void 0 && _tileError$error$root2.reason) {
    return tileError.error.root_cause[0].reason;
  }
  if ((_tileError$error2 = tileError.error) !== null && _tileError$error2 !== void 0 && _tileError$error2.reason) {
    return tileError.error.reason;
  }
  return tileError.message;
}