"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataSourceLabel = getDataSourceLabel;
exports.getDataViewLabel = getDataViewLabel;
exports.getDataViewNotFoundMessage = getDataViewNotFoundMessage;
exports.getDataViewSelectPlaceholder = getDataViewSelectPlaceholder;
exports.getEsSpatialRelationLabel = getEsSpatialRelationLabel;
exports.getUrlLabel = getUrlLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDataSourceLabel() {
  return _i18n.i18n.translate('xpack.maps.source.dataSourceLabel', {
    defaultMessage: 'Data source'
  });
}
function getUrlLabel() {
  return _i18n.i18n.translate('xpack.maps.source.urlLabel', {
    defaultMessage: 'Url'
  });
}
function getEsSpatialRelationLabel(spatialRelation) {
  switch (spatialRelation) {
    case 'intersects':
      return _i18n.i18n.translate('xpack.maps.common.esSpatialRelation.intersectsLabel', {
        defaultMessage: 'intersects'
      });
    case 'disjoint':
      return _i18n.i18n.translate('xpack.maps.common.esSpatialRelation.disjointLabel', {
        defaultMessage: 'disjoint'
      });
    case 'within':
      return _i18n.i18n.translate('xpack.maps.common.esSpatialRelation.withinLabel', {
        defaultMessage: 'within'
      });
    case 'contains':
      return _i18n.i18n.translate('xpack.maps.common.esSpatialRelation.containsLabel', {
        defaultMessage: 'contains'
      });
    default:
      return spatialRelation;
  }
}
function getDataViewLabel() {
  return _i18n.i18n.translate('xpack.maps.dataView.label', {
    defaultMessage: 'Data view'
  });
}
function getDataViewSelectPlaceholder() {
  return _i18n.i18n.translate('xpack.maps.dataView.selectPlacholder', {
    defaultMessage: 'Select data view'
  });
}
function getDataViewNotFoundMessage(id) {
  return _i18n.i18n.translate('xpack.maps.dataView.notFoundMessage', {
    defaultMessage: `Unable to find data view '{id}'`,
    values: {
      id
    }
  });
}