"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _contants = require("../common/contants");
var _locator = require("../common/locator");
var _management_sections_service = require("./management_sections_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LazyKibanaSettingsApplication = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-application')))).KibanaSettingsApplication
}));
const KibanaSettingsApplication = (0, _sharedUxUtility.withSuspense)(LazyKibanaSettingsApplication);
class ManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "managementSections", new _management_sections_service.ManagementSectionsService());
    (0, _defineProperty2.default)(this, "appUpdater", new _rxjs.BehaviorSubject(() => {
      const config = this.initializerContext.config.get();
      const navLinkStatus = _public.AppNavLinkStatus[config.deeplinks.navLinkStatus];
      const deepLinks = Object.values(this.managementSections.definedSections).map(section => ({
        id: section.id,
        title: section.title,
        navLinkStatus,
        deepLinks: section.getAppsEnabled().map(mgmtApp => ({
          id: mgmtApp.id,
          title: mgmtApp.title,
          path: mgmtApp.basePath,
          keywords: mgmtApp.keywords,
          navLinkStatus
        }))
      }));
      return {
        deepLinks
      };
    }));
    (0, _defineProperty2.default)(this, "hasAnyEnabledApps", true);
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "cardsNavigationConfig$", new _rxjs.BehaviorSubject({
      enabled: false,
      hideLinksTo: [],
      extendCardNavDefinitions: {}
    }));
    this.initializerContext = initializerContext;
  }
  setup(core, {
    home,
    share
  }) {
    const kibanaVersion = this.initializerContext.env.packageInfo.version;
    const locator = share.url.locators.create(new _locator.ManagementAppLocatorDefinition());
    const managementPlugin = this;
    if (home) {
      home.featureCatalogue.register({
        id: 'stack-management',
        title: _i18n.i18n.translate('management.stackManagement.managementLabel', {
          defaultMessage: 'Stack Management'
        }),
        description: _i18n.i18n.translate('management.stackManagement.managementDescription', {
          defaultMessage: 'Your center console for managing the Elastic Stack.'
        }),
        icon: 'managementApp',
        path: '/app/management',
        showOnHomePage: false,
        category: 'admin',
        visible: () => this.hasAnyEnabledApps
      });
    }
    core.application.register({
      id: _contants.MANAGEMENT_APP_ID,
      title: _i18n.i18n.translate('management.stackManagement.title', {
        defaultMessage: 'Stack Management'
      }),
      order: 9040,
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.management,
      updater$: this.appUpdater,
      async mount(params) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, deps] = await core.getStartServices();
        return renderApp(params, {
          sections: (0, _management_sections_service.getSectionsServiceStartPrivate)(),
          kibanaVersion,
          coreStart,
          setBreadcrumbs: newBreadcrumbs => {
            if (deps.serverless) {
              // drop the root management breadcrumb in serverless because it comes from the navigation tree
              const [, ...trailingBreadcrumbs] = newBreadcrumbs;
              deps.serverless.setBreadcrumbs(trailingBreadcrumbs);
            } else {
              coreStart.chrome.setBreadcrumbs(newBreadcrumbs);
            }
          },
          isSidebarEnabled$: managementPlugin.isSidebarEnabled$,
          cardsNavigationConfig$: managementPlugin.cardsNavigationConfig$
        });
      }
    });
    return {
      sections: this.managementSections.setup(),
      locator
    };
  }
  start(core, plugins) {
    this.managementSections.start({
      capabilities: core.application.capabilities
    });
    this.hasAnyEnabledApps = (0, _management_sections_service.getSectionsServiceStartPrivate)().getSectionsEnabled().some(section => section.getAppsEnabled().length > 0);
    if (!this.hasAnyEnabledApps) {
      this.appUpdater.next(() => {
        return {
          status: _public.AppStatus.inaccessible,
          navLinkStatus: _public.AppNavLinkStatus.hidden
        };
      });
    }

    // Register the Settings app only if in serverless, until we integrate the SettingsApplication into the Advanced settings plugin
    // Otherwise, it will be double registered from the Advanced settings plugin
    if (plugins.serverless) {
      const title = _i18n.i18n.translate('management.settings.settingsLabel', {
        defaultMessage: 'Advanced Settings'
      });
      this.managementSections.definedSections.kibana.registerApp({
        id: 'settings',
        title,
        order: 3,
        async mount({
          element,
          setBreadcrumbs,
          history
        }) {
          setBreadcrumbs([{
            text: title
          }]);
          _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(KibanaSettingsApplication, (0, _extends2.default)({}, core, {
            history
          }))), element);
          return () => {
            _reactDom.default.unmountComponentAtNode(element);
          };
        }
      });
    }
    return {
      setIsSidebarEnabled: isSidebarEnabled => this.isSidebarEnabled$.next(isSidebarEnabled),
      setupCardsNavigation: ({
        enabled,
        hideLinksTo,
        extendCardNavDefinitions
      }) => this.cardsNavigationConfig$.next({
        enabled,
        hideLinksTo,
        extendCardNavDefinitions
      })
    };
  }
}
exports.ManagementPlugin = ManagementPlugin;