"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logViewSavedObjectRT = exports.logViewSavedObjectFieldColumnConfigurationRT = exports.logViewSavedObjectColumnConfigurationRT = exports.logViewSavedObjectAttributesRT = exports.logIndexSavedObjectReferenceRT = exports.logIndexNameSavedObjectReferenceRT = exports.logDataViewSavedObjectReferenceRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _references = require("../references");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logDataViewSavedObjectReferenceRT = rt.type({
  type: rt.literal('data_view'),
  dataViewId: rt.string
});
exports.logDataViewSavedObjectReferenceRT = logDataViewSavedObjectReferenceRT;
const logIndexNameSavedObjectReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
exports.logIndexNameSavedObjectReferenceRT = logIndexNameSavedObjectReferenceRT;
const logIndexSavedObjectReferenceRT = rt.union([logDataViewSavedObjectReferenceRT, logIndexNameSavedObjectReferenceRT]);
exports.logIndexSavedObjectReferenceRT = logIndexSavedObjectReferenceRT;
const logViewSavedObjectCommonColumnConfigurationRT = rt.strict({
  id: rt.string
});
const logViewSavedObjectTimestampColumnConfigurationRT = rt.strict({
  timestampColumn: logViewSavedObjectCommonColumnConfigurationRT
});
const logViewSavedObjectMessageColumnConfigurationRT = rt.strict({
  messageColumn: logViewSavedObjectCommonColumnConfigurationRT
});
const logViewSavedObjectFieldColumnConfigurationRT = rt.strict({
  fieldColumn: rt.intersection([logViewSavedObjectCommonColumnConfigurationRT, rt.strict({
    field: rt.string
  })])
});
exports.logViewSavedObjectFieldColumnConfigurationRT = logViewSavedObjectFieldColumnConfigurationRT;
const logViewSavedObjectColumnConfigurationRT = rt.union([logViewSavedObjectTimestampColumnConfigurationRT, logViewSavedObjectMessageColumnConfigurationRT, logViewSavedObjectFieldColumnConfigurationRT]);
exports.logViewSavedObjectColumnConfigurationRT = logViewSavedObjectColumnConfigurationRT;
const logViewSavedObjectAttributesRT = rt.strict({
  name: rt.string,
  description: rt.string,
  logIndices: logIndexSavedObjectReferenceRT,
  logColumns: rt.array(logViewSavedObjectColumnConfigurationRT)
});
exports.logViewSavedObjectAttributesRT = logViewSavedObjectAttributesRT;
const logViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: logViewSavedObjectAttributesRT,
  references: rt.array(_references.savedObjectReferenceRT)
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);
exports.logViewSavedObjectRT = logViewSavedObjectRT;