"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogViewsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _log_views = require("../../../common/log_views");
var _log_views_client = require("./log_views_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogViewsService {
  constructor() {
    (0, _defineProperty2.default)(this, "logViewsStaticConfig", _log_views.defaultLogViewsStaticConfig);
  }
  setup() {
    return {
      setLogViewsStaticConfig: config => {
        this.logViewsStaticConfig = config;
      }
    };
  }
  start({
    dataViews,
    http,
    search
  }) {
    const client = new _log_views_client.LogViewsClient(dataViews, http, search.search, this.logViewsStaticConfig);
    return {
      client
    };
  }
}
exports.LogViewsService = LogViewsService;