"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateContextInUrl = exports.listenForUrlChanges = exports.initializeFromUrl = exports.getLogViewReferenceFromUrl = exports.defaultLogViewKey = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _public = require("@kbn/kibana-utils-plugin/public");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _function = require("fp-ts/lib/function");
var _rxjs = require("rxjs");
var _runtime_types = require("../../../../common/runtime_types");
var _log_views = require("../../../../common/log_views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLogViewKey = 'logView';
exports.defaultLogViewKey = defaultLogViewKey;
const defaultLegacySourceIdKey = 'sourceId';
const updateContextInUrl = ({
  urlStateStorage,
  logViewKey = defaultLogViewKey
}) => (context, _event) => {
  if (!('logViewReference' in context)) {
    throw new Error('Missing keys from context needed to sync to the URL');
  }
  urlStateStorage.set(logViewKey, logViewStateInUrlRT.encode(context.logViewReference), {
    replace: true
  });
};
exports.updateContextInUrl = updateContextInUrl;
const initializeFromUrl = ({
  logViewKey = defaultLogViewKey,
  sourceIdKey = defaultLegacySourceIdKey,
  toastsService,
  urlStateStorage
}) => (_context, _event) => send => {
  const logViewReference = getLogViewReferenceFromUrl({
    logViewKey,
    sourceIdKey,
    toastsService,
    urlStateStorage
  });
  send({
    type: 'INITIALIZED_FROM_URL',
    logViewReference
  });
};
exports.initializeFromUrl = initializeFromUrl;
const getLogViewReferenceFromUrl = ({
  logViewKey,
  sourceIdKey,
  toastsService,
  urlStateStorage
}) => {
  const logViewQueryValueFromUrl = urlStateStorage.get(logViewKey);
  const logViewQueryE = decodeLogViewQueryValueFromUrl(logViewQueryValueFromUrl);
  const legacySourceIdQueryValueFromUrl = urlStateStorage.get(sourceIdKey);
  const sourceIdQueryE = decodeSourceIdQueryValueFromUrl(legacySourceIdQueryValueFromUrl);
  if (Either.isLeft(logViewQueryE) || Either.isLeft(sourceIdQueryE)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _runtime_types.createPlainError)((0, _runtime_types.formatErrors)([...(Either.isLeft(logViewQueryE) ? logViewQueryE.left : []), ...(Either.isLeft(sourceIdQueryE) ? sourceIdQueryE.left : [])])));
    return null;
  } else {
    return (0, _function.pipe)(
    // Via the legacy sourceId key
    (0, _function.pipe)(sourceIdQueryE.right, Either.fromNullable(null), Either.map(convertSourceIdToReference)),
    // Via the logView key
    Either.alt(() => (0, _function.pipe)(logViewQueryE.right, Either.fromNullable(null))), Either.fold(_function.identity, _function.identity));
  }
};

// NOTE: Certain navigations within the Logs solution will remove the logView URL key,
// we want to ensure the logView key is present in the URL at all times by monitoring for it's removal.
exports.getLogViewReferenceFromUrl = getLogViewReferenceFromUrl;
const listenForUrlChanges = ({
  urlStateStorage,
  logViewKey = defaultLogViewKey
}) => (context, event) => {
  return urlStateStorage.change$(logViewKey).pipe((0, _rxjs.map)(value => value === undefined || value === null ? {
    type: 'LOG_VIEW_URL_KEY_REMOVED'
  } : {
    type: 'LOG_VIEW_URL_KEY_CHANGED'
  }));
};
exports.listenForUrlChanges = listenForUrlChanges;
const logViewStateInUrlRT = rt.union([_log_views.logViewReferenceRT, rt.null]);
const sourceIdStateInUrl = rt.union([rt.string, rt.null]);
const decodeLogViewQueryValueFromUrl = queryValueFromUrl => {
  return logViewStateInUrlRT.decode(queryValueFromUrl);
};
const decodeSourceIdQueryValueFromUrl = queryValueFromUrl => {
  return sourceIdStateInUrl.decode(queryValueFromUrl);
};
const convertSourceIdToReference = sourceId => {
  return {
    type: 'log-view-reference',
    logViewId: sourceId
  };
};