"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("../../../hooks/use_kibana");
var _log_column_render_configuration = require("../../../utils/log_column_render_configuration");
var _log_entry = require("../../../utils/log_entry");
var _log_entry_column = require("./log_entry_column");
var _log_entry_context_menu = require("./log_entry_context_menu");
var _log_entry_field_column = require("./log_entry_field_column");
var _log_entry_message_column = require("./log_entry_message_column");
var _log_entry_row_wrapper = require("./log_entry_row_wrapper");
var _log_entry_timestamp_column = require("./log_entry_timestamp_column");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MENU_LABEL = _i18n.i18n.translate('xpack.logsShared.logEntryItemView.logEntryActionsMenuToolTip', {
  defaultMessage: 'View actions for line'
});
const LOG_DETAILS_LABEL = _i18n.i18n.translate('xpack.logsShared.logs.logEntryActionsDetailsButton', {
  defaultMessage: 'View details'
});
const LOG_VIEW_IN_CONTEXT_LABEL = _i18n.i18n.translate('xpack.logsShared.lobs.logEntryActionsViewInContextButton', {
  defaultMessage: 'View in context'
});
const LogEntryRow = /*#__PURE__*/(0, _react.memo)(({
  boundingBoxRef,
  columnConfigurations,
  columnWidths,
  highlights,
  isActiveHighlight,
  isHighlighted,
  logEntry,
  openFlyoutWithItem,
  openViewLogInContext,
  scale,
  wrap
}) => {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_logs'
  });
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const openMenu = (0, _react.useCallback)(() => setIsMenuOpen(true), []);
  const closeMenu = (0, _react.useCallback)(() => setIsMenuOpen(false), []);
  const setItemIsHovered = (0, _react.useCallback)(() => setIsHovered(true), []);
  const setItemIsNotHovered = (0, _react.useCallback)(() => setIsHovered(false), []);
  const openFlyout = (0, _react.useCallback)(() => openFlyoutWithItem === null || openFlyoutWithItem === void 0 ? void 0 : openFlyoutWithItem(logEntry.id), [openFlyoutWithItem, logEntry.id]);
  const handleOpenViewLogInContext = (0, _react.useCallback)(() => {
    openViewLogInContext === null || openViewLogInContext === void 0 ? void 0 : openViewLogInContext(logEntry);
    trackMetric({
      metric: 'view_in_context__stream'
    });
  }, [openViewLogInContext, logEntry, trackMetric]);
  const hasContext = (0, _react.useMemo)(() => !(0, _lodash.isEmpty)(logEntry.context), [logEntry]);
  const hasActionFlyoutWithItem = openFlyoutWithItem !== undefined;
  const hasActionViewLogInContext = hasContext && openViewLogInContext !== undefined;
  const hasActionsMenu = hasActionFlyoutWithItem || hasActionViewLogInContext;
  const uiActions = (0, _use_kibana.useKibanaContextForPlugin)().services.uiActions;
  const externalContextMenuItems = (0, _useAsync.default)(() => {
    return (0, _public.getContextMenuItemsFromActions)({
      uiActions,
      triggerId: _common.ObservabilityTriggerId.LogEntryContextMenu,
      context: logEntry
    });
  }, [uiActions, logEntry]);
  const menuItems = (0, _react.useMemo)(() => {
    const items = [];
    if (hasActionFlyoutWithItem) {
      items.push({
        label: LOG_DETAILS_LABEL,
        onClick: openFlyout
      });
    }
    if (hasActionViewLogInContext) {
      items.push({
        label: LOG_VIEW_IN_CONTEXT_LABEL,
        onClick: handleOpenViewLogInContext
      });
    }
    return items;
  }, [hasActionFlyoutWithItem, hasActionViewLogInContext, openFlyout, handleOpenViewLogInContext]);
  const logEntryColumnsById = (0, _react.useMemo)(() => logEntry.columns.reduce((columnsById, column) => ({
    ...columnsById,
    [column.columnId]: column
  }), {}), [logEntry.columns]);
  const highlightsByColumnId = (0, _react.useMemo)(() => highlights.reduce((columnsById, highlight) => highlight.columns.reduce((innerColumnsById, column) => ({
    ...innerColumnsById,
    [column.columnId]: [...(innerColumnsById[column.columnId] || []), column]
  }), columnsById), {}), [highlights]);
  return /*#__PURE__*/_react.default.createElement(_log_entry_row_wrapper.LogEntryRowWrapper, {
    "data-test-subj": "streamEntry logTextStreamEntry",
    ref: /* Workaround for missing RefObject support in styled-components */
    boundingBoxRef,
    onMouseEnter: setItemIsHovered,
    onMouseLeave: setItemIsNotHovered,
    isHighlighted: isHighlighted,
    scale: scale
  }, columnConfigurations.map(columnConfiguration => {
    if ((0, _log_column_render_configuration.isTimestampColumnRenderConfiguration)(columnConfiguration)) {
      const column = logEntryColumnsById[columnConfiguration.timestampColumn.id];
      const columnWidth = columnWidths[columnConfiguration.timestampColumn.id];
      return /*#__PURE__*/_react.default.createElement(_log_entry_column.LogEntryColumn, (0, _extends2.default)({
        "data-test-subj": "logColumn timestampLogColumn",
        key: columnConfiguration.timestampColumn.id
      }, columnWidth), (0, _log_entry.isTimestampColumn)(column) ? /*#__PURE__*/_react.default.createElement(_log_entry_timestamp_column.LogEntryTimestampColumn, {
        time: column.time,
        render: columnConfiguration.timestampColumn.render
      }) : null);
    } else if ((0, _log_column_render_configuration.isMessageColumnRenderConfiguration)(columnConfiguration)) {
      const column = logEntryColumnsById[columnConfiguration.messageColumn.id];
      const columnWidth = columnWidths[columnConfiguration.messageColumn.id];
      return /*#__PURE__*/_react.default.createElement(_log_entry_column.LogEntryColumn, (0, _extends2.default)({
        "data-test-subj": "logColumn messageLogColumn",
        key: columnConfiguration.messageColumn.id
      }, columnWidth), column ? /*#__PURE__*/_react.default.createElement(_log_entry_message_column.LogEntryMessageColumn, {
        columnValue: column,
        highlights: highlightsByColumnId[column.columnId] || [],
        isActiveHighlight: isActiveHighlight,
        wrapMode: wrap ? 'long' : 'pre-wrapped',
        render: columnConfiguration.messageColumn.render
      }) : null);
    } else if ((0, _log_column_render_configuration.isFieldColumnRenderConfiguration)(columnConfiguration)) {
      const column = logEntryColumnsById[columnConfiguration.fieldColumn.id];
      const columnWidth = columnWidths[columnConfiguration.fieldColumn.id];
      return /*#__PURE__*/_react.default.createElement(_log_entry_column.LogEntryColumn, (0, _extends2.default)({
        "data-test-subj": `logColumn fieldLogColumn fieldLogColumn:${columnConfiguration.fieldColumn.field}`,
        key: columnConfiguration.fieldColumn.id
      }, columnWidth), column ? /*#__PURE__*/_react.default.createElement(_log_entry_field_column.LogEntryFieldColumn, {
        columnValue: column,
        highlights: highlightsByColumnId[column.columnId] || [],
        isActiveHighlight: isActiveHighlight,
        wrapMode: wrap ? 'long' : 'pre-wrapped',
        render: columnConfiguration.fieldColumn.render
      }) : null);
    }
  }), hasActionsMenu ? /*#__PURE__*/_react.default.createElement(_log_entry_column.LogEntryColumn, (0, _extends2.default)({
    key: "logColumn iconLogColumn iconLogColumn:details"
  }, columnWidths[_log_entry_column.iconColumnId]), isHovered || isMenuOpen ? /*#__PURE__*/_react.default.createElement(_log_entry_context_menu.LogEntryContextMenu, {
    "aria-label": MENU_LABEL,
    isOpen: isMenuOpen,
    onOpen: openMenu,
    onClose: closeMenu,
    items: menuItems,
    externalItems: externalContextMenuItems.value
  }) : null) : null);
});

// eslint-disable-next-line import/no-default-export
exports.LogEntryRow = LogEntryRow;
var _default = LogEntryRow;
exports.default = _default;