"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogColumnHeadersWrapper = void 0;
var _common = require("@kbn/kibana-react-plugin/common");
var _polished = require("polished");
var _vertical_scroll_panel = require("./vertical_scroll_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogColumnHeadersWrapper = _common.euiStyled.div.attrs(props => {
  var _props$role;
  return {
    role: (_props$role = props.role) !== null && _props$role !== void 0 ? _props$role : 'row'
  };
})`
    align-items: stretch;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    justify-content: flex-start;
    overflow: hidden;
    padding-right: ${_vertical_scroll_panel.ASSUMED_SCROLLBAR_WIDTH}px;
    border-bottom: ${props => props.theme.eui.euiBorderThin};
    box-shadow: 0 2px 2px -1px ${props => (0, _polished.transparentize)(0.3, props.theme.eui.euiColorLightShade)};
    position: relative;
    z-index: 1;
  `;

// eslint-disable-next-line import/no-default-export
exports.LogColumnHeadersWrapper = LogColumnHeadersWrapper;
var _default = LogColumnHeadersWrapper;
exports.default = _default;