"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationsContext = exports.IntegrationsProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _react2 = require("@xstate/react");
var _integrations = require("../state_machines/integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrations = ({
  datasetsClient
}) => {
  const integrationsStateService = (0, _react2.useInterpret)(() => (0, _integrations.createIntegrationStateMachine)({
    datasetsClient
  }));
  const integrations = (0, _react2.useSelector)(integrationsStateService, state => state.context.integrations);
  const error = (0, _react2.useSelector)(integrationsStateService, state => state.context.error);
  const isLoading = (0, _react2.useSelector)(integrationsStateService, state => state.matches('loading'));
  const isSearching = (0, _react2.useSelector)(integrationsStateService, state => state.matches({
    loaded: 'loadingMore'
  }) || state.matches({
    loaded: 'debounceSearchingIntegrations'
  }) || state.matches({
    loaded: 'debounceSearchingIntegrationsStreams'
  }));
  const searchIntegrations = (0, _react.useCallback)(searchParams => integrationsStateService.send({
    type: 'SEARCH_INTEGRATIONS',
    search: formatSearchParams(searchParams)
  }), [integrationsStateService]);
  const sortIntegrations = (0, _react.useCallback)(searchParams => integrationsStateService.send({
    type: 'SORT_INTEGRATIONS',
    search: formatSearchParams(searchParams)
  }), [integrationsStateService]);
  const searchIntegrationsStreams = (0, _react.useCallback)(searchParams => integrationsStateService.send({
    type: 'SEARCH_INTEGRATIONS_STREAMS',
    search: formatSearchParams(searchParams)
  }), [integrationsStateService]);
  const sortIntegrationsStreams = (0, _react.useCallback)(searchParams => integrationsStateService.send({
    type: 'SORT_INTEGRATIONS_STREAMS',
    search: formatSearchParams(searchParams)
  }), [integrationsStateService]);
  const reloadIntegrations = (0, _react.useCallback)(() => integrationsStateService.send({
    type: 'RELOAD_INTEGRATIONS'
  }), [integrationsStateService]);
  const loadMore = (0, _react.useCallback)(() => integrationsStateService.send({
    type: 'LOAD_MORE_INTEGRATIONS'
  }), [integrationsStateService]);
  return {
    // Underlying state machine
    integrationsStateService,
    // Failure states
    error,
    // Loading states
    isLoading,
    isSearching,
    // Data
    integrations,
    // Actions
    loadMore,
    reloadIntegrations,
    searchIntegrations,
    sortIntegrations,
    searchIntegrationsStreams,
    sortIntegrationsStreams
  };
};
const [IntegrationsProvider, useIntegrationsContext] = (0, _constate.default)(useIntegrations);

/**
 * Utils
 */
exports.useIntegrationsContext = useIntegrationsContext;
exports.IntegrationsProvider = IntegrationsProvider;
const formatSearchParams = ({
  name,
  ...params
}) => ({
  nameQuery: name,
  ...params
});