"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CustomDatasetSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _dataset_selector = require("../components/dataset_selector");
var _use_datasets = require("../hooks/use_datasets");
var _use_dataset_selection = require("../hooks/use_dataset_selection");
var _use_data_views = require("../hooks/use_data_views");
var _use_esql = require("../hooks/use_esql");
var _use_integrations = require("../hooks/use_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomDatasetSelector = withProviders(({
  logExplorerProfileStateService
}) => {
  const {
    datasetSelection,
    handleDatasetSelectionChange
  } = (0, _use_dataset_selection.useDatasetSelection)(logExplorerProfileStateService);
  const {
    error: integrationsError,
    integrations,
    isLoading: isLoadingIntegrations,
    isSearching: isSearchingIntegrations,
    loadMore,
    reloadIntegrations,
    searchIntegrations,
    searchIntegrationsStreams,
    sortIntegrations,
    sortIntegrationsStreams
  } = (0, _use_integrations.useIntegrationsContext)();
  const {
    datasets,
    error: datasetsError,
    isLoading: isLoadingUncategorized,
    loadDatasets,
    reloadDatasets,
    searchDatasets,
    sortDatasets
  } = (0, _use_datasets.useDatasetsContext)();
  const {
    dataViews,
    error: dataViewsError,
    isLoading: isLoadingDataViews,
    loadDataViews,
    reloadDataViews,
    selectDataView,
    searchDataViews,
    sortDataViews
  } = (0, _use_data_views.useDataViewsContext)();
  const {
    isEsqlEnabled,
    discoverEsqlUrlProps
  } = (0, _use_esql.useEsql)({
    datasetSelection
  });
  return /*#__PURE__*/_react.default.createElement(_dataset_selector.DatasetSelector, {
    datasets: datasets,
    datasetSelection: datasetSelection,
    datasetsError: datasetsError,
    dataViews: dataViews,
    dataViewsError: dataViewsError,
    discoverEsqlUrlProps: discoverEsqlUrlProps,
    integrations: integrations,
    integrationsError: integrationsError,
    isEsqlEnabled: isEsqlEnabled,
    isLoadingDataViews: isLoadingDataViews,
    isLoadingIntegrations: isLoadingIntegrations,
    isLoadingUncategorized: isLoadingUncategorized,
    isSearchingIntegrations: isSearchingIntegrations,
    onDataViewSelection: selectDataView,
    onDataViewsReload: reloadDataViews,
    onDataViewsSearch: searchDataViews,
    onDataViewsSort: sortDataViews,
    onDataViewsTabClick: loadDataViews,
    onIntegrationsLoadMore: loadMore,
    onIntegrationsReload: reloadIntegrations,
    onIntegrationsSearch: searchIntegrations,
    onIntegrationsSort: sortIntegrations,
    onIntegrationsStreamsSearch: searchIntegrationsStreams,
    onIntegrationsStreamsSort: sortIntegrationsStreams,
    onSelectionChange: handleDatasetSelectionChange,
    onUncategorizedReload: reloadDatasets,
    onUncategorizedSearch: searchDatasets,
    onUncategorizedSort: sortDatasets,
    onUncategorizedTabClick: loadDatasets
  });
});

// eslint-disable-next-line import/no-default-export
exports.CustomDatasetSelector = CustomDatasetSelector;
var _default = CustomDatasetSelector;
exports.default = _default;
function withProviders(Component) {
  return function ComponentWithProviders({
    datasetsClient,
    dataViews,
    discover,
    logExplorerProfileStateService
  }) {
    return /*#__PURE__*/_react.default.createElement(_use_integrations.IntegrationsProvider, {
      datasetsClient: datasetsClient
    }, /*#__PURE__*/_react.default.createElement(_use_datasets.DatasetsProvider, {
      datasetsClient: datasetsClient
    }, /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
      dataViewsService: dataViews,
      discoverService: discover
    }, /*#__PURE__*/_react.default.createElement(Component, {
      logExplorerProfileStateService: logExplorerProfileStateService
    }))));
  };
}