"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevel = LogLevel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEVEL_DICT = {
  error: 'danger',
  warn: 'warning',
  info: 'primary',
  default: 'default'
};
function LogLevel({
  level
}) {
  var _LEVEL_DICT$level;
  if (!level) return null;
  const levelColor = (_LEVEL_DICT$level = LEVEL_DICT[level]) !== null && _LEVEL_DICT$level !== void 0 ? _LEVEL_DICT$level : LEVEL_DICT.default;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: levelColor,
    "data-test-subj": "logExplorerFlyoutLogLevel"
  }, level);
}