"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightField = HighlightField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../translations");
var _use_discover_action = require("../../../hooks/use_discover_action");
var _hover_popover_action = require("./hover_popover_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HighlightField({
  field,
  formattedValue,
  icon,
  label,
  value,
  width,
  ...props
}) {
  const filterForText = (0, _translations.flyoutHoverActionFilterForText)(value);
  const filterOutText = (0, _translations.flyoutHoverActionFilterOutText)(value);
  const actions = (0, _use_discover_action.useDiscoverActionsContext)();
  const [columnAdded, setColumnAdded] = (0, _react.useState)(false);
  const hoverActions = (0, _react.useMemo)(() => [{
    id: 'addToFilterAction',
    tooltipContent: filterForText,
    iconType: 'plusInCircle',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter(field, value, '+'),
    display: true
  }, {
    id: 'removeFromFilterAction',
    tooltipContent: filterOutText,
    iconType: 'minusInCircle',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter(field, value, '-'),
    display: true
  }, {
    id: 'filterForFieldPresentAction',
    tooltipContent: _translations.flyoutHoverActionFilterForFieldPresentText,
    iconType: 'filter',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter('_exists_', field, '+'),
    display: true
  }, {
    id: 'toggleColumnAction',
    tooltipContent: _translations.flyoutHoverActionToggleColumnText,
    iconType: 'listAdd',
    onClick: () => {
      if (actions) {
        if (columnAdded) {
          var _actions$removeColumn;
          actions === null || actions === void 0 ? void 0 : (_actions$removeColumn = actions.removeColumn) === null || _actions$removeColumn === void 0 ? void 0 : _actions$removeColumn.call(actions, field);
        } else {
          var _actions$addColumn;
          actions === null || actions === void 0 ? void 0 : (_actions$addColumn = actions.addColumn) === null || _actions$addColumn === void 0 ? void 0 : _actions$addColumn.call(actions, field);
        }
        setColumnAdded(!columnAdded);
      }
    },
    display: true
  }, {
    id: 'copyToClipboardAction',
    tooltipContent: _translations.flyoutHoverActionCopyToClipboardText,
    iconType: 'copyClipboard',
    onClick: () => (0, _eui.copyToClipboard)(value),
    display: true
  }], [filterForText, filterOutText, actions, field, value, columnAdded]);
  return formattedValue ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    direction: "column",
    gutterSize: "none"
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    actions: hoverActions,
    title: value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
    text: formattedValue,
    truncation: "end",
    width: width
  }, truncatedText => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
    // Value returned from formatFieldValue is always sanitized
    ,
    dangerouslySetInnerHTML: {
      __html: truncatedText
    }
  }))))))) : null;
}