"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const panelStyle = {
  width: _constants.DATA_VIEW_POPOVER_CONTENT_WIDTH
};
const DatasetsPopover = ({
  children,
  onClick,
  selection,
  ...props
}) => {
  var _parentIntegration$na, _parentIntegration$ve;
  const {
    iconType,
    parentIntegration
  } = selection.dataset;
  const title = selection.dataset.getFullTitle();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const buttonStyles = (0, _utils.getPopoverButtonStyles)({
    fullWidth: isMobile
  });
  const hasIntegration = typeof parentIntegration === 'object';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    id: _constants.POPOVER_ID,
    "data-test-subj": "datasetSelectorPopover",
    anchorPosition: isMobile ? 'downCenter' : 'downLeft',
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      css: buttonStyles,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onClick,
      fullWidth: isMobile,
      "data-test-subj": "datasetSelectorPopoverButton"
    }, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType
    }) : hasIntegration ? /*#__PURE__*/_react.default.createElement(_public.PackageIcon, {
      packageName: (_parentIntegration$na = parentIntegration.name) !== null && _parentIntegration$na !== void 0 ? _parentIntegration$na : '',
      version: (_parentIntegration$ve = parentIntegration.version) !== null && _parentIntegration$ve !== void 0 ? _parentIntegration$ve : '1.0.0',
      icons: parentIntegration.icons,
      size: "m",
      tryApi: true
    }) : null, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate"
    }, title)),
    panelPaddingSize: "none",
    buffer: 8
  }, isMobile && {
    display: 'block'
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    css: panelStyle,
    "data-test-subj": "datasetSelectorContent"
  }, children));
};
exports.DatasetsPopover = DatasetsPopover;