"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetSelector = void 0;
var _react = require("react");
var _react2 = require("@xstate/react");
var _state_machine = require("./state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetSelector = ({
  initialContext,
  onDataViewSelection,
  onDataViewsSearch,
  onDataViewsSort,
  onIntegrationsLoadMore,
  onIntegrationsReload,
  onIntegrationsSearch,
  onIntegrationsSort,
  onIntegrationsStreamsSearch,
  onIntegrationsStreamsSort,
  onSelectionChange,
  onUncategorizedSearch,
  onUncategorizedSort,
  onUncategorizedReload
}) => {
  const datasetsSelectorStateService = (0, _react2.useInterpret)(() => (0, _state_machine.createDatasetsSelectorStateMachine)({
    initialContext,
    onDataViewSelection,
    onDataViewsSearch,
    onDataViewsSort,
    onIntegrationsLoadMore,
    onIntegrationsReload,
    onIntegrationsSearch,
    onIntegrationsSort,
    onIntegrationsStreamsSearch,
    onIntegrationsStreamsSort,
    onSelectionChange,
    onUncategorizedSearch,
    onUncategorizedSort,
    onUncategorizedReload
  }));
  const isOpen = (0, _react2.useSelector)(datasetsSelectorStateService, state => state.matches('popover.open'));
  const panelId = (0, _react2.useSelector)(datasetsSelectorStateService, state => state.context.panelId);
  const search = (0, _react2.useSelector)(datasetsSelectorStateService, state => state.context.search);
  const selection = (0, _react2.useSelector)(datasetsSelectorStateService, state => state.context.selection);
  const tabId = (0, _react2.useSelector)(datasetsSelectorStateService, state => state.context.tabId);
  const switchToIntegrationsTab = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'SWITCH_TO_INTEGRATIONS_TAB'
  }), [datasetsSelectorStateService]);
  const switchToUncategorizedTab = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'SWITCH_TO_UNCATEGORIZED_TAB'
  }), [datasetsSelectorStateService]);
  const switchToDataViewsTab = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'SWITCH_TO_DATA_VIEWS_TAB'
  }), [datasetsSelectorStateService]);
  const changePanel = (0, _react.useCallback)(panelDetails => datasetsSelectorStateService.send({
    type: 'CHANGE_PANEL',
    panelId: panelDetails.panelId
  }), [datasetsSelectorStateService]);
  const scrollToIntegrationsBottom = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'SCROLL_TO_INTEGRATIONS_BOTTOM'
  }), [datasetsSelectorStateService]);
  const searchByName = (0, _react.useCallback)(params => datasetsSelectorStateService.send({
    type: 'SEARCH_BY_NAME',
    search: params
  }), [datasetsSelectorStateService]);
  const selectAllLogDataset = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'SELECT_ALL_LOGS_DATASET'
  }), [datasetsSelectorStateService]);
  const selectDataset = (0, _react.useCallback)(dataset => datasetsSelectorStateService.send({
    type: 'SELECT_DATASET',
    dataset
  }), [datasetsSelectorStateService]);
  const selectDataView = (0, _react.useCallback)(dataView => datasetsSelectorStateService.send({
    type: 'SELECT_DATA_VIEW',
    dataView
  }), [datasetsSelectorStateService]);
  const sortByOrder = (0, _react.useCallback)(params => datasetsSelectorStateService.send({
    type: 'SORT_BY_ORDER',
    search: params
  }), [datasetsSelectorStateService]);
  const closePopover = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'CLOSE'
  }), [datasetsSelectorStateService]);
  const togglePopover = (0, _react.useCallback)(() => datasetsSelectorStateService.send({
    type: 'TOGGLE'
  }), [datasetsSelectorStateService]);
  return {
    // Data
    panelId,
    search,
    selection,
    tabId,
    // Flags
    isOpen,
    isAllMode: selection.selectionType === 'all',
    // Actions
    changePanel,
    closePopover,
    scrollToIntegrationsBottom,
    searchByName,
    selectAllLogDataset,
    selectDataset,
    selectDataView,
    sortByOrder,
    switchToIntegrationsTab,
    switchToUncategorizedTab,
    switchToDataViewsTab,
    togglePopover
  };
};
exports.useDatasetSelector = useDatasetSelector;