"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unresolvedDatasetSelectionPlainRT = exports.singleDatasetSelectionPlainRT = exports.datasetSelectionPlainRT = exports.allDatasetSelectionPlainRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _datasets = require("../datasets");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('all')
});
exports.allDatasetSelectionPlainRT = allDatasetSelectionPlainRT;
const integrationNameRT = rt.partial({
  name: rt.string
});
const integrationTitleRT = rt.partial({
  title: rt.string
});
const integrationVersionRT = rt.partial({
  version: rt.string
});
const singleDatasetSelectionPayloadRT = rt.intersection([integrationNameRT, integrationTitleRT, integrationVersionRT, rt.type({
  dataset: _datasets.datasetRT
})]);
const unresolvedDatasetSelectionPayloadRT = rt.intersection([integrationNameRT, rt.type({
  dataset: _datasets.datasetRT
})]);
const singleDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('single'),
  selection: singleDatasetSelectionPayloadRT
});
exports.singleDatasetSelectionPlainRT = singleDatasetSelectionPlainRT;
const unresolvedDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('unresolved'),
  selection: unresolvedDatasetSelectionPayloadRT
});
exports.unresolvedDatasetSelectionPlainRT = unresolvedDatasetSelectionPlainRT;
const datasetSelectionPlainRT = rt.union([allDatasetSelectionPlainRT, singleDatasetSelectionPlainRT, unresolvedDatasetSelectionPlainRT]);
exports.datasetSelectionPlainRT = datasetSelectionPlainRT;