"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.duplicateExceptionListAndItems = void 0;
var _uuid = require("uuid");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _find_exception_list_items_point_in_time_finder = require("./find_exception_list_items_point_in_time_finder");
var _bulk_create_exception_list_items = require("./bulk_create_exception_list_items");
var _create_exception_list = require("./create_exception_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LISTS_ABLE_TO_DUPLICATE = [_securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION.toString(), _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT.toString()];
const duplicateExceptionListAndItems = async ({
  includeExpiredExceptions,
  list,
  savedObjectsClient,
  namespaceType,
  user
}) => {
  // Generate a new static listId
  const newListId = (0, _uuid.v4)();
  if (!LISTS_ABLE_TO_DUPLICATE.includes(list.type)) {
    return null;
  }
  const newlyCreatedList = await (0, _create_exception_list.createExceptionList)({
    description: list.description,
    immutable: list.immutable,
    listId: newListId,
    meta: list.meta,
    name: `${list.name} [Duplicate]`,
    namespaceType: list.namespace_type,
    savedObjectsClient,
    tags: list.tags,
    type: list.type,
    user,
    version: 1
  });

  // fetch associated items
  let itemsToBeDuplicated = [];
  const executeFunctionOnStream = response => {
    const transformedItems = response.data.map(item => {
      // Generate a new static listId
      const newItemId = (0, _uuid.v4)();
      return {
        comments: [],
        description: item.description,
        entries: item.entries,
        expire_time: item.expire_time,
        item_id: newItemId,
        list_id: newlyCreatedList.list_id,
        meta: item.meta,
        name: item.name,
        namespace_type: item.namespace_type,
        os_types: item.os_types,
        tags: item.tags,
        type: item.type
      };
    });
    itemsToBeDuplicated = [...itemsToBeDuplicated, ...transformedItems];
  };
  const savedObjectPrefix = (0, _securitysolutionListUtils.getSavedObjectType)({
    namespaceType
  });
  const filter = includeExpiredExceptions ? [] : [`(${savedObjectPrefix}.attributes.expire_time > "${new Date().toISOString()}" OR NOT ${savedObjectPrefix}.attributes.expire_time: *)`];
  await (0, _find_exception_list_items_point_in_time_finder.findExceptionListsItemPointInTimeFinder)({
    executeFunctionOnStream,
    filter,
    listId: [list.list_id],
    maxSize: 10000,
    namespaceType: [namespaceType],
    perPage: undefined,
    savedObjectsClient,
    sortField: undefined,
    sortOrder: undefined
  });
  await (0, _bulk_create_exception_list_items.bulkCreateExceptionListItems)({
    items: itemsToBeDuplicated,
    savedObjectsClient,
    user
  });
  return newlyCreatedList;
};
exports.duplicateExceptionListAndItems = duplicateExceptionListAndItems;