"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE = exports.OR = exports.OPERATOR = exports.FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = exports.FIELD = exports.EXCEPTION_OPERATOR_PLACEHOLDER = exports.EXCEPTION_FIELD_VALUE_PLACEHOLDER = exports.EXCEPTION_FIELD_PLACEHOLDER = exports.EXCEPTION_FIELD_NESTED_PLACEHOLDER = exports.EXCEPTION_FIELD_LISTS_PLACEHOLDER = exports.CUSTOM_COMBOBOX_OPTION_TEXT = exports.CONFLICT_MULTIPLE_INDEX_DESCRIPTION = exports.AND = exports.ADD_NON_NESTED_DESCRIPTION = exports.ADD_NESTED_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD = _i18n.i18n.translate('xpack.lists.exceptions.builder.fieldLabel', {
  defaultMessage: 'Field'
});
exports.FIELD = FIELD;
const OPERATOR = _i18n.i18n.translate('xpack.lists.exceptions.builder.operatorLabel', {
  defaultMessage: 'Operator'
});
exports.OPERATOR = OPERATOR;
const VALUE = _i18n.i18n.translate('xpack.lists.exceptions.builder.valueLabel', {
  defaultMessage: 'Value'
});
exports.VALUE = VALUE;
const EXCEPTION_FIELD_VALUE_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldValuePlaceholder', {
  defaultMessage: 'Search field value...'
});
exports.EXCEPTION_FIELD_VALUE_PLACEHOLDER = EXCEPTION_FIELD_VALUE_PLACEHOLDER;
const EXCEPTION_FIELD_NESTED_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldNestedPlaceholder', {
  defaultMessage: 'Search nested field'
});
exports.EXCEPTION_FIELD_NESTED_PLACEHOLDER = EXCEPTION_FIELD_NESTED_PLACEHOLDER;
const EXCEPTION_FIELD_LISTS_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionListsPlaceholder', {
  defaultMessage: 'Search for list...'
});
exports.EXCEPTION_FIELD_LISTS_PLACEHOLDER = EXCEPTION_FIELD_LISTS_PLACEHOLDER;
const EXCEPTION_FIELD_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionFieldPlaceholder', {
  defaultMessage: 'Search'
});
exports.EXCEPTION_FIELD_PLACEHOLDER = EXCEPTION_FIELD_PLACEHOLDER;
const EXCEPTION_OPERATOR_PLACEHOLDER = _i18n.i18n.translate('xpack.lists.exceptions.builder.exceptionOperatorPlaceholder', {
  defaultMessage: 'Operator'
});
exports.EXCEPTION_OPERATOR_PLACEHOLDER = EXCEPTION_OPERATOR_PLACEHOLDER;
const ADD_NESTED_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.builder.addNestedDescription', {
  defaultMessage: 'Add nested condition'
});
exports.ADD_NESTED_DESCRIPTION = ADD_NESTED_DESCRIPTION;
const ADD_NON_NESTED_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.builder.addNonNestedDescription', {
  defaultMessage: 'Add non-nested condition'
});
exports.ADD_NON_NESTED_DESCRIPTION = ADD_NON_NESTED_DESCRIPTION;
const AND = _i18n.i18n.translate('xpack.lists.exceptions.andDescription', {
  defaultMessage: 'AND'
});
exports.AND = AND;
const OR = _i18n.i18n.translate('xpack.lists.exceptions.orDescription', {
  defaultMessage: 'OR'
});
exports.OR = OR;
const CUSTOM_COMBOBOX_OPTION_TEXT = _i18n.i18n.translate('xpack.lists.exceptions.comboBoxCustomOptionText', {
  defaultMessage: 'Select a field from the list. If your field is not available, create a custom one.'
});
exports.CUSTOM_COMBOBOX_OPTION_TEXT = CUSTOM_COMBOBOX_OPTION_TEXT;
const FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = _i18n.i18n.translate('xpack.lists.exceptions.field.mappingConflict.description', {
  defaultMessage: 'This field is defined as different types across the following indices or is unmapped. This can cause unexpected query results.'
});
exports.FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION = FIELD_CONFLICT_INDICES_WARNING_DESCRIPTION;
const CONFLICT_MULTIPLE_INDEX_DESCRIPTION = (name, count) => _i18n.i18n.translate('xpack.lists.exceptions.field.index.description', {
  defaultMessage: '{name} ({count} indices)',
  values: {
    count,
    name
  }
});
exports.CONFLICT_MULTIPLE_INDEX_DESCRIPTION = CONFLICT_MULTIPLE_INDEX_DESCRIPTION;