"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/dashboard-plugin/public");
var _common = require("../../common");
var _embeddable = require("../../common/embeddable");
var _links_strings = require("../components/links_strings");
var _attribute_service = require("../services/attribute_service");
var _kibana_services = require("../services/kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
// TODO: Replace string 'OPEN_FLYOUT_ADD_DRILLDOWN' with constant once the dashboardEnhanced plugin is removed
// and it is no longer locked behind `x-pack`
const getDefaultLinksInput = () => ({
  disabledActions: ['OPEN_FLYOUT_ADD_DRILLDOWN']
});
const isLinksAttributes = attributes => {
  return attributes !== undefined && Boolean(attributes.layout || attributes.links);
};
class LinksFactoryDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "latestVersion", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "migrations", void 0);
    (0, _defineProperty2.default)(this, "grouping", void 0);
    (0, _defineProperty2.default)(this, "type", _common.CONTENT_ID);
    (0, _defineProperty2.default)(this, "isContainerType", false);
    (0, _defineProperty2.default)(this, "savedObjectMetaData", {
      name: _common.APP_NAME,
      type: _common.CONTENT_ID,
      getIconForSavedObject: () => _common.APP_ICON
    });
    (0, _defineProperty2.default)(this, "getPanelPlacementSettings", (input, attributes) => {
      var _attributes$links$len, _attributes$links;
      if (!isLinksAttributes(attributes) || !attributes.layout) {
        // if we have no information about the layout of this links panel defer to default panel size and placement.
        return {};
      }
      const isHorizontal = attributes.layout === 'horizontal';
      const width = isHorizontal ? _public.DASHBOARD_GRID_COLUMN_COUNT : 8;
      const height = isHorizontal ? 4 : ((_attributes$links$len = (_attributes$links = attributes.links) === null || _attributes$links === void 0 ? void 0 : _attributes$links.length) !== null && _attributes$links$len !== void 0 ? _attributes$links$len : 1 * 3) + 4;
      return {
        width,
        height,
        strategy: 'placeAtTop'
      };
    });
    (0, _defineProperty2.default)(this, "inject", _embeddable.inject);
    (0, _defineProperty2.default)(this, "extract", _embeddable.extract);
  }
  async isEditable() {
    var _coreServices$applica;
    await (0, _kibana_services.untilPluginStartServicesReady)();
    return Boolean((_coreServices$applica = _kibana_services.coreServices.application.capabilities.dashboard) === null || _coreServices$applica === void 0 ? void 0 : _coreServices$applica.showWriteControls);
  }
  canCreateNew() {
    return _kibana_services.presentationUtil.labsService.isProjectEnabled('labs:dashboard:linksPanel');
  }
  getDefaultInput() {
    return getDefaultLinksInput();
  }
  async createFromSavedObject(savedObjectId, input, parent) {
    if (!input.savedObjectId) {
      input.savedObjectId = savedObjectId;
    }
    return this.create(input, parent);
  }
  async create(initialInput, parent) {
    await (0, _kibana_services.untilPluginStartServicesReady)();
    const {
      LinksEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./links_embeddable')));
    const editable = await this.isEditable();
    return new LinksEmbeddable({
      editable
    }, {
      ...getDefaultLinksInput(),
      ...initialInput
    }, (0, _attribute_service.getLinksAttributeService)(), parent);
  }
  async getExplicitInput(initialInput, parent) {
    const {
      openEditorFlyout
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../editor/open_editor_flyout')));
    const {
      newInput,
      attributes
    } = await openEditorFlyout({
      ...getDefaultLinksInput(),
      ...initialInput
    }, parent);
    return {
      newInput,
      attributes
    };
  }
  getDisplayName() {
    return _common.APP_NAME;
  }
  getIconType() {
    return 'link';
  }
  getDescription() {
    return _links_strings.LinksStrings.getDescription();
  }
}
exports.LinksFactoryDefinition = LinksFactoryDefinition;