"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openEditorFlyout = openEditorFlyout;
var _react = _interopRequireDefault(require("react"));
var _operators = require("rxjs/operators");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _save_to_library = require("../content_management/save_to_library");
var _attribute_service = require("../services/attribute_service");
var _kibana_services = require("../services/kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LazyLinksEditor = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/editor/links_editor'))));
const LinksEditor = (0, _sharedUxUtility.withSuspense)(LazyLinksEditor, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  className: "eui-textCenter"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "l"
})));

/**
 * @throws in case user cancels
 */
async function openEditorFlyout(initialInput, parentDashboard) {
  const attributeService = (0, _attribute_service.getLinksAttributeService)();
  const {
    attributes
  } = await attributeService.unwrapAttributes(initialInput);
  const isByReference = attributeService.inputIsRefType(initialInput);
  const initialLinks = attributes === null || attributes === void 0 ? void 0 : attributes.links;
  const overlayTracker = parentDashboard && (0, _public.tracksOverlays)(parentDashboard) ? parentDashboard : undefined;
  if (!initialLinks) {
    /**
     * When creating a new links panel, the tooltip from the "Add panel" popover interacts badly with the flyout
     * and can cause a "double opening" animation if the flyout opens before the tooltip has time to unmount; so,
     * when creating a new links panel, we need to slow down the process a little bit so that the tooltip has time
     * to disappear before we try to open the flyout.
     *
     * This does not apply to editing existing links panels, since there is no tooltip for this action.
     */
    await new Promise(resolve => setTimeout(resolve, 50));
  }
  return new Promise((resolve, reject) => {
    const closeEditorFlyout = editorFlyout => {
      if (overlayTracker) {
        overlayTracker.clearOverlays();
      } else {
        editorFlyout.close();
      }
    };

    /**
     * Close the flyout whenever the app changes - this handles cases for when the flyout is open outside of the
     * Dashboard app (`overlayTracker` is not available)
     */
    _kibana_services.coreServices.application.currentAppId$.pipe((0, _operators.skip)(1), (0, _operators.take)(1)).subscribe(() => {
      if (!overlayTracker) editorFlyout.close();
    });
    const onSaveToLibrary = async (newLinks, newLayout) => {
      const newAttributes = {
        ...attributes,
        links: newLinks,
        layout: newLayout
      };
      const updatedInput = initialInput.savedObjectId ? await attributeService.wrapAttributes(newAttributes, true, initialInput) : await (0, _save_to_library.runSaveToLibrary)(newAttributes, initialInput);
      if (!updatedInput) {
        return;
      }
      resolve({
        newInput: updatedInput,
        // pass attributes via attributes so that the Dashboard can choose the right panel size.
        attributes: newAttributes
      });
      parentDashboard === null || parentDashboard === void 0 ? void 0 : parentDashboard.reload();
      closeEditorFlyout(editorFlyout);
    };
    const onAddToDashboard = (newLinks, newLayout) => {
      const newAttributes = {
        ...attributes,
        links: newLinks,
        layout: newLayout
      };
      const newInput = {
        ...initialInput,
        attributes: newAttributes
      };
      resolve({
        newInput,
        // pass attributes so that the Dashboard can choose the right panel size.
        attributes: newAttributes
      });
      parentDashboard === null || parentDashboard === void 0 ? void 0 : parentDashboard.reload();
      closeEditorFlyout(editorFlyout);
    };
    const onCancel = () => {
      reject();
      closeEditorFlyout(editorFlyout);
    };
    const editorFlyout = _kibana_services.coreServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(LinksEditor, {
      initialLinks: initialLinks,
      initialLayout: attributes === null || attributes === void 0 ? void 0 : attributes.layout,
      onClose: onCancel,
      onSaveToLibrary: onSaveToLibrary,
      onAddToDashboard: onAddToDashboard,
      parentDashboard: parentDashboard,
      isByReference: isByReference
    }), {
      theme: _kibana_services.coreServices.theme,
      i18n: _kibana_services.coreServices.i18n
    }), {
      maxWidth: 720,
      ownFocus: true,
      outsideClickCloses: false,
      onClose: onCancel,
      className: 'linksPanelEditor',
      'data-test-subj': 'links--panelEditor--flyout'
    });
    if (overlayTracker) {
      overlayTracker.openOverlay(editorFlyout);
    }
  });
}